/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.acl;

import java.security.Principal;
import org.w3c.jigsaw.acl.HTTPPermission;
import org.w3c.jigsaw.acl.JAcl;
import org.w3c.jigsaw.acl.SecurityLevel;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.StringAttribute;
import org.w3c.www.http.HttpChallenge;

public class AclFilter
extends ResourceFilter {
    protected static int ATTR_SECURITY_LEVEL = -1;
    protected static int ATTR_ALGORITHM = -1;
    protected static int ATTR_NONCE_TTL = -1;
    protected static int ATTR_STRICT_ACL_MERGE_POLICY = -1;
    protected static int ATTR_SHARED_CACHABILITY = -1;
    protected static int ATTR_PRIVATE_CACHABILITY = -1;
    protected static int ATTR_PUBLIC_CACHABILITY = -1;
    protected static int ATTR_LENIENT = -1;
    protected static Class JAcl_class = null;
    protected SecurityLevel security = null;

    static {
        SimpleAttribute simpleAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.acl.AclFilter");
            JAcl_class = Class.forName("org.w3c.jigsaw.acl.JAcl");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        simpleAttribute = new IntegerAttribute("security-level", new Integer(0), 2);
        ATTR_SECURITY_LEVEL = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("strict-acl-merge-policy", Boolean.TRUE, 2);
        ATTR_STRICT_ACL_MERGE_POLICY = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new StringAttribute("algorithm", null, 2);
        ATTR_ALGORITHM = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new IntegerAttribute("nonce_ttl", new Integer(300), 2);
        ATTR_NONCE_TTL = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("shared-cachability", Boolean.FALSE, 2);
        ATTR_SHARED_CACHABILITY = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("private-cachability", Boolean.FALSE, 2);
        ATTR_PRIVATE_CACHABILITY = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("public-cachability", Boolean.FALSE, 2);
        ATTR_PUBLIC_CACHABILITY = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("lenient", Boolean.FALSE, 2);
        ATTR_LENIENT = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }

    protected void authenticate(Request request, JAcl[] jAclArray) throws ProtocolException {
        HTTPPermission hTTPPermission = new HTTPPermission(request);
        Principal principal = this.security.getPrincipal(request, this.getAlgorithm());
        boolean bl = this.isStrictAclMergePolicy();
        boolean bl2 = false;
        JAcl jAcl = jAclArray[0];
        if (principal != null) {
            boolean bl3;
            int n;
            if (bl) {
                bl2 = true;
                n = 0;
                while (n < jAclArray.length) {
                    bl3 = jAclArray[n].checkPermission(principal, hTTPPermission);
                    if (!bl3) {
                        bl2 = false;
                        jAcl = jAclArray[n];
                        break;
                    }
                    ++n;
                }
            } else {
                n = 0;
                while (n < jAclArray.length) {
                    bl3 = jAclArray[n].checkPermission(principal, hTTPPermission);
                    if (bl3) {
                        bl2 = true;
                        break;
                    }
                    ++n;
                }
            }
        }
        if (!bl2) {
            HttpChallenge httpChallenge = this.security.getChallenge(jAcl.getName(), principal);
            Reply reply = null;
            if (request.isProxy()) {
                reply = request.makeReply(407);
                reply.setProxyAuthenticate(httpChallenge);
            } else {
                reply = request.makeReply(401);
                reply.setWWWAuthenticate(httpChallenge);
            }
            HtmlGenerator htmlGenerator = new HtmlGenerator("Unauthorized");
            htmlGenerator.append("<h1>Unauthorized access</h1><p>You are denied access to this resource.");
            reply.setStream(htmlGenerator);
            request.skipBody();
            throw new HTTPException(reply);
        }
        this.security.updateRequestStates(request, principal);
    }

    protected JAcl[] getAcls() {
        ResourceFrame[] resourceFrameArray = this.collectFrames(JAcl_class);
        JAcl[] jAclArray = new JAcl[resourceFrameArray.length];
        int n = 0;
        while (n < resourceFrameArray.length) {
            jAclArray[n] = (JAcl)resourceFrameArray[n];
            ++n;
        }
        return jAclArray;
    }

    public String getAlgorithm() {
        return (String)this.getValue(ATTR_ALGORITHM, (Object)"MD5");
    }

    public int getNonceTTL() {
        return this.getInt(ATTR_NONCE_TTL, 300);
    }

    public boolean getPrivateCachability() {
        return this.getBoolean(ATTR_PRIVATE_CACHABILITY, false);
    }

    public boolean getPublicCachability() {
        return this.getBoolean(ATTR_PUBLIC_CACHABILITY, false);
    }

    public int getSecurityLevel() {
        return this.getInt(ATTR_SECURITY_LEVEL, 0);
    }

    public boolean getSharedCachability() {
        return this.getBoolean(ATTR_SHARED_CACHABILITY, false);
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        this.security = SecurityLevel.getSecurityLevel(this);
    }

    public boolean isLenient() {
        return this.getBoolean(ATTR_LENIENT, false);
    }

    public boolean isStrictAclMergePolicy() {
        return this.getBoolean(ATTR_STRICT_ACL_MERGE_POLICY, true);
    }

    public boolean lookup(LookupState lookupState, LookupResult lookupResult) throws ProtocolException {
        JAcl[] jAclArray = this.getAcls();
        if (jAclArray == null || lookupState.getRequest() == null) {
            return false;
        }
        this.authenticate((Request)lookupState.getRequest(), jAclArray);
        return false;
    }

    public ReplyInterface outgoingFilter(RequestInterface requestInterface, ReplyInterface replyInterface) {
        Reply reply = (Reply)replyInterface;
        if (this.getPrivateCachability()) {
            reply.setMustRevalidate(true);
        } else if (this.getSharedCachability()) {
            reply.setProxyRevalidate(true);
        } else if (this.getPublicCachability()) {
            reply.setPublic(true);
        }
        this.security.updateReply(reply, (Request)requestInterface);
        return null;
    }

    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_SECURITY_LEVEL || n == ATTR_ALGORITHM || n == ATTR_LENIENT) {
            this.security = SecurityLevel.getSecurityLevel(this);
        }
    }
}

