/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.util.Enumeration;
import org.w3c.util.ArrayDictionary;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpInvalidValueException;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.ParseState;

public class HttpBag
extends BasicValue {
    boolean isToplevel = false;
    String name = null;
    ArrayDictionary items = null;

    HttpBag() {
        this.isValid = false;
        this.items = new ArrayDictionary(5, 5);
    }

    HttpBag(boolean bl, String string) {
        this.isValid = bl;
        this.name = string;
        this.items = new ArrayDictionary(5, 5);
    }

    public void addBag(HttpBag httpBag) {
        this.validate();
        this.items.put(httpBag.getName(), httpBag);
    }

    public void addItem(String string) {
        this.validate();
        this.items.put(string, Boolean.TRUE);
    }

    public void addItem(HttpBag httpBag) {
        this.validate();
        this.items.put(httpBag.getName(), httpBag);
    }

    public HttpBag getBag(String string) {
        this.validate();
        if (this.hasBag(string)) {
            return (HttpBag)this.items.get(string);
        }
        return null;
    }

    public String getName() {
        this.validate();
        return this.name;
    }

    public Object getValue() {
        return this;
    }

    public boolean hasBag(String string) {
        this.validate();
        Object object = this.items.get(string);
        return object != null && object instanceof HttpBag;
    }

    public boolean hasItem(String string) {
        this.validate();
        return this.items.get(string) != null;
    }

    public boolean isToplevelBag() {
        return this.isToplevel;
    }

    public Enumeration keys() {
        this.validate();
        return this.items.keys();
    }

    protected final void parse() throws HttpParserException {
        int n = this.roff;
        this.isToplevel = true;
        HttpBag httpBag = this;
        while (n < this.rlen) {
            switch (this.raw[n]) {
                case 123: {
                    ParseState parseState = new ParseState(n, this.rlen);
                    HttpBag httpBag2 = this.parseBag(parseState);
                    httpBag.items.put(httpBag2.name, httpBag2);
                    n = parseState.ooff;
                    break;
                }
                case 9: 
                case 32: 
                case 44: {
                    ++n;
                    break;
                }
                default: {
                    this.error("Unexpected separator \"" + this.raw[n] + "\".");
                }
            }
        }
    }

    protected HttpBag parseBag(ParseState parseState) throws HttpParserException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = parseState.ioff;
        byte by = this.raw[n];
        while (n < parseState.bufend && (by = this.raw[n]) <= 32) {
            ++n;
        }
        if (n >= parseState.bufend) {
            return null;
        }
        if (by != 123) {
            this.error("Invalid Bag format (no {).");
        }
        ++n;
        while (n < parseState.bufend && (by = this.raw[n]) <= 32) {
            ++n;
        }
        if (n >= parseState.bufend) {
            this.error("Invalid Bag format (no name).");
        }
        while (n < parseState.bufend && (by = this.raw[n]) > 32 && by != 125) {
            stringBuffer.append((char)by);
            ++n;
        }
        HttpBag httpBag = new HttpBag(true, stringBuffer.toString());
        while (n < parseState.bufend) {
            by = this.raw[n];
            if (by <= 32) {
                ++n;
                continue;
            }
            if (by == 125) {
                parseState.ooff = n + 1;
                return httpBag;
            }
            if (by == 123) {
                ParseState parseState2 = new ParseState(n, parseState.bufend);
                HttpBag httpBag2 = this.parseBag(parseState2);
                httpBag.items.put(httpBag2.name, httpBag2);
                n = parseState2.ooff;
                continue;
            }
            if (by == 34) {
                stringBuffer.setLength(0);
                ++n;
                while (n < parseState.bufend && (by = this.raw[n]) != 34) {
                    stringBuffer.append((char)by);
                    ++n;
                }
                httpBag.items.put(stringBuffer.toString(), Boolean.TRUE);
                ++n;
                continue;
            }
            stringBuffer.setLength(0);
            while (n < parseState.bufend && (by = this.raw[n]) > 32 && by != 125) {
                stringBuffer.append((char)by);
                ++n;
            }
            httpBag.addItem(stringBuffer.toString());
        }
        return httpBag;
    }

    public void removeItem(String string) {
        this.validate();
        this.items.remove(string);
    }

    protected final void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        if (this.isToplevel) {
            Enumeration enumeration = this.items.elements();
            boolean bl = true;
            while (enumeration.hasMoreElements()) {
                HttpBag httpBag = (HttpBag)enumeration.nextElement();
                if (bl) {
                    bl = false;
                } else {
                    httpBuffer.append((byte)44);
                }
                httpBag.appendValue(httpBuffer);
            }
        } else {
            httpBuffer.append((byte)123);
            httpBuffer.append(this.name);
            httpBuffer.append((byte)32);
            Enumeration enumeration = this.items.keys();
            boolean bl = true;
            while (enumeration.hasMoreElements()) {
                if (bl) {
                    bl = false;
                } else {
                    httpBuffer.append((byte)32);
                }
                String string = (String)enumeration.nextElement();
                Object object = this.items.get(string);
                if (object instanceof Boolean) {
                    httpBuffer.append(string);
                    continue;
                }
                if (object instanceof HttpBag) {
                    ((HttpBag)object).appendValue(httpBuffer);
                    continue;
                }
                String string2 = "Invalid bag item value, key=\"" + string + "\".";
                throw new HttpInvalidValueException(string2);
            }
            httpBuffer.append((byte)125);
        }
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }
}

