/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import org.w3c.www.http.HttpStreamObserver;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeParserFactory;
import org.w3c.www.protocol.http.HttpBasicServer;
import org.w3c.www.protocol.http.HttpConnection;
import org.w3c.www.protocol.http.HttpServer;

class HttpBasicConnection
extends HttpConnection
implements HttpStreamObserver {
    private static final boolean debug = false;
    static Method sock_m = null;
    private Socket socket = null;
    MimeParser parser = null;
    OutputStream output = null;
    InputStream input = null;
    MimeParserFactory reply_factory = null;
    Thread th = null;
    InetAddress inetaddr = null;
    int port = -1;
    int timeout = 300000;
    int connect_timeout = 3000;
    protected int id = -1;
    protected boolean closeOnEOF = false;
    protected Thread old_th = null;
    static /* synthetic */ Class class$java$net$Socket;

    static {
        try {
            Class clazz = class$java$net$Socket != null ? class$java$net$Socket : (class$java$net$Socket = HttpBasicConnection.class$("java.net.Socket"));
            sock_m = clazz.getMethod("isClosed", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            sock_m = null;
        }
    }

    HttpBasicConnection(HttpServer httpServer, int n, InetAddress inetAddress, int n2, int n3, int n4, MimeParserFactory mimeParserFactory) throws IOException {
        this.server = httpServer;
        this.inetaddr = inetAddress;
        this.port = n2;
        this.id = n;
        this.timeout = n3;
        this.connect_timeout = n4;
        this.reply_factory = mimeParserFactory;
    }

    HttpBasicConnection(HttpServer httpServer, int n, InetAddress inetAddress, int n2, int n3, MimeParserFactory mimeParserFactory) throws IOException {
        this(httpServer, n, inetAddress, n2, n3, 3000, mimeParserFactory);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public synchronized void close() {
        this.close(false);
    }

    private synchronized void close(boolean bl) {
        boolean bl2 = this.socket != null || bl;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {}
        this.socket = null;
        this.output = null;
        this.input = null;
        this.parser = null;
        this.cached = false;
        this.th = null;
        this.old_th = null;
        if (bl2) {
            ((HttpBasicServer)this.server).deleteConnection(this);
        }
    }

    protected synchronized void detach() {
        boolean bl = this.socket != null;
        this.socket = null;
        this.output = null;
        this.input = null;
        this.parser = null;
        this.cached = false;
        this.th = null;
        this.old_th = null;
        if (bl) {
            ((HttpBasicServer)this.server).deleteConnection(this);
        }
    }

    public void finalize() {
        if (this.socket != null) {
            this.close();
        }
    }

    public OutputStream getOutputStream() {
        if (this.output == null) {
            throw new RuntimeException("getOutputStream while disconnected.");
        }
        return this.output;
    }

    public MimeParser getParser() {
        if (this.parser == null) {
            throw new RuntimeException("getParser while disconnected.");
        }
        return this.parser;
    }

    public void markIdle(boolean bl) {
        HttpBasicConnection httpBasicConnection = this;
        synchronized (httpBasicConnection) {
            if (this.th == null) {
                Object var3_3 = null;
                return;
            }
            this.old_th = this.th;
            this.th = null;
        }
        if (bl) {
            this.close();
        } else {
            ((HttpBasicServer)this.server).registerConnection(this);
        }
    }

    public boolean markUsed() {
        Object object;
        block18: {
            this.cached = false;
            if (this.th != null) {
                throw new RuntimeException(String.valueOf(String.valueOf(this)) + " already used by " + this.th);
            }
            this.th = Thread.currentThread();
            if (this.socket != null) {
                this.cached = true;
                if (sock_m != null) {
                    try {
                        object = (Boolean)sock_m.invoke((Object)this.socket, null);
                        if (!((Boolean)object).booleanValue()) break block18;
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {}
                        this.socket = null;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {}
                        this.socket = null;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {}
                        this.socket = null;
                    }
                    catch (Exception exception) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {}
                        this.socket = null;
                    }
                }
            }
        }
        if (this.socket == null) {
            try {
                object = new TimedSocket();
                this.socket = ((TimedSocket)object).getSocket(this.inetaddr, this.port);
                this.socket.setSoTimeout(this.timeout);
                this.output = new BufferedOutputStream(this.socket.getOutputStream());
                this.input = new BufferedInputStream(this.socket.getInputStream());
                this.parser = new MimeParser(this.input, this.reply_factory);
                this.cached = false;
            }
            catch (Throwable throwable) {
                this.close(true);
                return false;
            }
        }
        return true;
    }

    protected boolean mayReuse() {
        if (this.old_th != null) {
            Thread thread = Thread.currentThread();
            return this.old_th == thread;
        }
        return true;
    }

    public synchronized void notifyClose(InputStream inputStream) {
        boolean bl = false;
        try {
            try {
                if (inputStream.available() > 0) {
                    bl = true;
                }
            }
            catch (IOException iOException) {
                bl = true;
            }
            Object var4_3 = null;
            this.markIdle(bl);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.markIdle(bl);
            throw throwable;
        }
    }

    public synchronized void notifyEOF(InputStream inputStream) {
        this.markIdle(this.closeOnEOF);
    }

    public synchronized void notifyFailure(InputStream inputStream) {
        this.markIdle(true);
    }

    public void notifyInputAvailable(InputStream inputStream) {
    }

    protected synchronized void setCloseOnEOF(boolean bl) {
        this.closeOnEOF = bl;
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.inetaddr)) + ":" + this.port + "[" + this.id + "]";
    }

    private class TimedSocket
    implements Runnable {
        Socket _sock = null;
        InetAddress _inetaddr = null;
        int _port = 0;
        boolean _ok = true;
        IOException _ioex = null;

        TimedSocket() {
        }

        public synchronized Socket getSocket(InetAddress inetAddress, int n) throws IOException {
            block6: {
                this._inetaddr = inetAddress;
                this._port = n;
                Thread thread = new Thread(this);
                thread.start();
                try {
                    thread.join(HttpBasicConnection.this.connect_timeout);
                }
                catch (InterruptedException interruptedException) {
                    this._ok = false;
                    if (this._sock == null) break block6;
                    try {
                        this._sock.close();
                    }
                    catch (IOException iOException) {}
                    this._sock = null;
                }
            }
            if (this._sock != null) {
                return this._sock;
            }
            this._ok = false;
            if (this._ioex != null) {
                throw this._ioex;
            }
            throw new IOException("Connect timed out");
        }

        public void run() {
            Socket socket = null;
            try {
                socket = new Socket(HttpBasicConnection.this.inetaddr, HttpBasicConnection.this.port);
            }
            catch (IOException iOException) {
                this._ioex = iOException;
            }
            if (this._ok) {
                this._sock = socket;
            } else {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

