FUNCTION diag(
	x	/MATRIX,ANY,NAOK/
	nrow	/INT,OPTIONAL/
	ncol	/INT,OPTIONAL/
	)
STATIC( integer n,p,otmode )
otmode=MODE(x)
COERCE(x/MATRIX,REAL,NAOK/)
if(NCOL(x)==1 | !MISSING(nrow) | !MISSING(ncol)) {	#make a matrix
	if(LENGTH(x)==1) {	#identity matrix
		if(NA(x))FATAL(Missing value not allowed)
		n=x; p=n; x=1.
		}
	else {
		n=LENGTH(x); p=n
		}
	if(!MISSING(nrow))n=nrow
	if(!MISSING(ncol))p=ncol
	STRUCTURE(y/MATRIX,n,p/)
	call rfill(0.,y,n*p)
	jj = 0
	for(i=0; i<min0(n,p); i=i+1) {
		ii=mod(i,LENGTH(x))
		call pcopy(VALUE(x)+ii,VALUE(y)+jj,1,REAL)
		jj = jj+n+1
		}
	COERCE(y/MATRIX,MODECALC(otmode)/)
	}
else { #get the diagonal
	n=min0(NROW(x),NCOL(x))
	STRUCTURE(y/REAL,n/)
	jj = 0
	for(i=0;i<n;i=i+1){
		call pcopy(VALUE(x)+jj,VALUE(y)+i,1,REAL)
		jj = jj+NROW(x)+1
		}
	COERCE(y/MODECALC(otmode)/)
	}
RETURN(y)
END
