FUNCTION lowess(
	x	/REAL/
	y	/REAL/
	f	/REAL,1,.6667/
	iter	/INT,1,3/
	delta	/REAL,1,0./
	)
STRUCTURE(
	rw	/REAL,LENGTH(x)/
	scr	/REAL,LENGTH(x)/
	ysort	/LIKE(y)/
	)
CHECK(LENGTH(x)==LENGTH(y),FATAL(x and y must have same length))
CHECK(LENGTH(x)>1,FATAL(need at least 2 data points))
CHECK(f>0 & f<=1,FATAL(f invalid))
CHECK(LENGTH(x)*f>=2,FATAL(f too small))

call sortpr(x,LENGTH(x),ysort)

if(MISSING(delta))
	delta = .01*(x[LENGTH(x)]-x[1])

call lowess(x,ysort,LENGTH(x),f,iter,delta,y,rw,scr)
iout=1	# eliminate duplicate points
for(i=2; i<=LENGTH(x); i=i+1)
	if(x[i]!=x[iout]){	# distinct value
		iout=iout+1
		if(iout!=i) { x[iout]=x[i]; y[iout]=y[i] }
		}
LENGTH(x)=iout; LENGTH(y)=iout

RETURN(x,y)
END
