#dstclq		compute quantiles for probfun
subroutine dstclq(x,n,par1,npar1,par2,npar2,whichf,naflag)
real x(1); integer n,whichf,npar1,npar2; logical naflag; POINTER par1,par2
# x: vector of quantiles, quantiles to be overwritten into it
# n: length of x
# par1,par2: value pointers for parameters of dist., checked by dstpar
# npar1,npar2: length of parameter vectors
# whichf: code for distribution
# naflag: flag set to TRUE iff NA's were generated from range checks

INCLUDE(struct, dist)
external qnorm,qlogi,qlnor,qtdis,qgamm,qcauc,qchis,qbeta,qf

PAR1=par1; PAR2=par2; NPAR1=npar1; NPAR2=npar2; NVALUES=n; WHICH=whichf #move values to common
switch(whichf) {
case NORM_DIST: call dstcq1(x,qnorm)
case LOGIS_DIST: call dstcq1(x,qlogi)
case LNORM_DIST: call dstcq1(x,qlnor)
case F_DIST: call dstcq1(x,qf)
case BETA_DIST: call dstcq1(x,qbeta)
case T_DIST: call dstcq1(x,qtdis)
case CAUCHY_DIST: call dstcq1(x,qcauc)
case GAMMA_DIST: call dstcq1(x,qgamm)
case CHISQ_DIST: call dstcq1(x,qchis)
case UNIF_DIST: call dstcq1(x,qnorm) #dummy
default: FATAL(invalid quantile distribution)
	}
naflag=NAFLAG
return
end

#dstcq1		inner layer of dstclq, using common block, supplied function
subroutine dstcq1(x,qufun)
real x(1),qufun
external qufun

INCLUDE(stack, struct, dist)
define(`NA_ACTION',`{NASET(x(i)); NAFLAG=TRUE; next}')
integer i
NAFLAG=FALSE; i1=0; i2=0
for(i=1; i<=NVALUES; i=i+1) {
	if(NA(x(i),REAL))next
	else switch(WHICH/10) { # switch on type of distribution
	case NORMAL_TYPE: if(x(i)==0. | x(i)==1.)NA_ACTION
		 x(i)=qufun(x(i),rs(PAR1+i1),rs(PAR2+i2)) # 2 pars, inf range
	case CHISQ_TYPE: if(x(i)==1.)NA_ACTION
		x(i)=qufun(x(i),rs(PAR1+i1)) # 1 parameter, semi-inf. range
	case F_TYPE: if(x(i)==1. & WHICH==F_DIST)NA_ACTION
		x(i)=qufun(x(i),rs(PAR1+i1),rs(PAR2+i2)) # 2 pars, not inf. range
	case T_TYPE: if(x(i)==0. | x(i)==1.)NA_ACTION
			x(i)=qufun(x(i),rs(PAR1+i1)) #1 par., inf. range
	case UNIF_TYPE: x(i)=rs(PAR1+i1)+x(i)*(rs(PAR2+i2)-rs(PAR1+i1))
		}
	i1=i1+1; if(i1==NPAR1)i1=0; i2=i2+1; if(i2==NPAR2)i2=0
	}
return
end
