#include <usercore.h>
#include <sunwindow/window_hs.h>
INCLUDE(device, hook)

#define am(i)		bgrp_[i-1]
#define FOREVER		2147483647
#define SET		0
#define GET		1

float F77_COM(bgrp)[200];
float aspect;
float char_width = 0.02, char_height = 0.02;
float initwhich[] = {0,252,253,254,255};
float initred[] = {1,1,1,1,0};
float initgreen[] = {1,1,0,1,0};
float initblue[] = {1,1,0,1,0};
#define NINIT	(sizeof(initwhich)/sizeof(float))
struct vwsurf vws, *surface = &vws;
struct rect r;
int ask = 1;
int color = 0;
int colorpos = SCR_WEST;
int nseg = 1;

F77_SUB(pbegnz, real=par, int=n)
{
	r_pbegnz(F_REALP(par),F_INTP(n));
}

static r_pbegnz(par, n)
float par[];
long *n;
{
	int i;
	char *av[4];
	char *getenv(), *gfx, *me;
	float zero = 0, one = 1;

	if(*n >= 1)
		ask = par[0];
	if(*n >= 2)
		color = par[1];
	if(*n >= 3)
		colorpos = par[2] < 0 ? colorpos : par[2];

	/* find the surface on which to do the graphics */
	i = 0;
	av[i++] = "";
	if(color) {
		av[i++] = "-d";
		av[i++] = "/dev/cgone0";
	}
	av[i++] = 0;
	if(get_view_surface(surface, av))
		FATAL(Cannot initialize sun device driver);

	/* don't blanket a tty subwindow */
	gfx = getenv("WINDOW_GFX");
	me = getenv("WINDOW_ME");
	if(gfx && me && strcmp(gfx, me) == 0)
		surface->flags = VWSURF_NEWFLG;

	/* prepare for output */
	if(initialize_core(BUFFERED, SYNCHRONOUS, TWOD))
		FATAL(Cannot initialize SunCore)
	surface->cmapsize = 256;
	if(initialize_view_surface(surface, FALSE))
		FATAL(Cannot initialize view surface);
	if(select_view_surface(surface))
		FATAL(Cannot select view surface);
	win_getsize(surface->windowfd, &r);
	aspect = (float)r.r_height / (float)r.r_width;
	set_ndc_space_2(1.0, aspect);
	set_viewport_2(0.0, 1.0, 0.0, aspect);
	set_window(0.0, 1.0, 0.0, 1.0);

	/* prepare for input */
	initialize_device(LOCATOR, 1);
	set_echo_surface(LOCATOR, 1, surface);
	set_echo(LOCATOR, 1, 1);	/* pointing finger cursor */
	for(i = 1; i <= 3; i++) {
		initialize_device(BUTTON, i);
		set_echo_surface(BUTTON, i, surface);
	}

	/* fill the amodes array */
	fill_am();

	/* open segment and initialize character primitive static attributes */
	create_retained_segment(nseg = 1);
	set_charprecision(`CHARACTER');
	set_charsize(char_width, char_height);
	set_font(STICK);
	color_table(NINIT, initwhich, initred, initgreen, initblue, SET);

	/* establish the relative positions of the b&w and color monitors */
	if(color && colorscreen(surface->windowfd))
		WARNING(Cannot extend cursor domain to color screen);
}

F77_SUB(zlinsz, real=x, real=y, int=n)
{
	r_zlinsz(F_REALP(x), F_REALP(y), F_INTP(n));
}

static r_zlinsz(x, y, n)
float x[], y[];
long *n;
{
	if(*n <= 0)
		return;
	move_abs_2(x[0], y[0]);
	polyline_abs_2(&x[1], &y[1], (int)*n - 1);
}

F77_SUB(zpntsz, real=x, real=y, int=n)
{
	r_zpntsz(F_REALP(x), F_REALP(y), F_INTP(n));
}

static r_zpntsz(x, y, n)
float x[], y[];
long *n;
{
	char buf[2];
	int i, s;

	if(*n <= 0)
		return;
	polymarker_abs_2(x, y, (int)*n);
}

F77_SUB(zpolyz, real=x, real=y, int=n)
{
	r_zpolyz(F_REALP(x), F_REALP(y), F_INTP(n));
}

static r_zpolyz(x, y, n)
float x[], y[];
long *n;
{
	if(*n <= 0)
		return;
	polygon_abs_2(x, y, (int)*n);
	/*
	move_abs_2(x[0], y[0]);
	polyline_abs_2(&x[1], &y[1], (int)*n - 1);
	polyline_abs_2(&x[0], &y[0], 1);
	*/
}

F77_SUB(zsegsz, real=x1, real=y1, real=x2, real=y2, int=n)
{
	r_zsegsz(F_REALP(x1), F_REALP(y1), F_REALP(x2), F_REALP(y2), F_INTP(n));
}

static r_zsegsz(x1, y1, x2, y2, n)
float x1[], y1[], x2[], y2[];
long *n;
{
	int i;

	for(i = 0; i < *n; i++) {
		move_abs_2(*x1++, *y1++);
		line_abs_2(*x2++, *y2++);
	}
}

F77_SUB(ztextz, real=x, real=y, char=string, int=nch, real=adj)
{
	r_ztextz(F_REALP(x), F_REALP(y), F_CHARP(string), F_INTP(nch), F_REALP(adj));
}
static r_ztextz(x, y, string, nch, adj)
char *string;
float *x, *y, *adj;
long *nch;
{
	float dx, dy, nx, ny;
	float vxmin, vxmax, vymin, vymax;
	float wxmin, wxmax, wymin, wymax;
	char *buf, *malloc();

	buf = malloc(*nch + 1);
	if(buf == (char *)0)
		FATAL(Cannot allocate memory for ztextz)
	strncpy(buf, string, *nch);
	buf[*nch]='\0';

	/*
	 * To keep a constant aspect ratio for characters, we
	 * first find the desired string position in NDC space,
	 * then open a new segment with world coords which match
	 * NDC space.  This string is plotted, and the remembered
	 * previous viewport and window are restored in another
	 * retained segment.
	 */
	map_world_to_ndc_2(*x, *y, &nx, &ny);
	inquire_viewport_2(&vxmin, &vxmax, &vymin, &vymax);
	inquire_window(&wxmin, &wxmax, &wymin, &wymax);
	close_retained_segment(nseg);
	set_charsize(am(18)*char_width*0.5, am(18)*char_height*0.5);
	set_viewport_2(0.0, 1.0, 0.0, aspect);
	set_window(0.0, 1.0, 0.0, aspect);
	create_retained_segment(++nseg);
	inquire_text_extent_2(buf, &dx, &dy);
	move_abs_2(nx - *adj * dx, ny - *adj * dy);
	text(buf);
	close_retained_segment(nseg);
	set_viewport_2(vxmin, vxmax, vymin, vymax);
	set_window(wxmin, wxmax, wymin, wymax);
	create_retained_segment(++nseg);
	free(buf);
}

struct raster {
	int width, height, depth;
	short *bits;
};

F77_SUB(zhookz, int=type, real=x, int=n, real=y, int=m)
{
	r_zhookz(F_INTP(type), F_REALP(x), F_INTP(n), F_REALP(y), F_INTP(m));
}

static r_zhookz(type, x, n, y, m)
long *type, *n, *m;
float x[], y[];
{
	int ndef, nword, butnum;
	float ax, ay, bx, by, t;
	struct raster raster;

	switch(*type) {
	case SET_COLOR_TABLE:
		*m = 0;
		ndef = *n / 4;
		color_table(ndef, x, x+ndef, x+2*ndef, x+3*ndef, SET);
		break;
	case GET_COLOR_TABLE:
		ndef = *n;
		if(*m != 3*ndef) {
			fprintf(stderr, "zhookz(`GET_COLOR_TABLE'): 3*%d != %d",
				ndef, *m);
			*m = 0;
			return;
		}
		color_table(ndef, x, y, y+ndef, y+2*ndef, GET);
		break;
	case PUT_RASTER:
		*m = 0;
		move_abs_2(x[0], x[1]);
		x += 2;
		raster.width = *x++;
		raster.height = *x++;
		raster.depth = color ? 8 : 1;
		raster.bits = (short *)x;
		nword = color
			? ((raster.width + 1) / 2) * raster.height
			: ((raster.width + 15) / 16) * raster.height; 
		if((nword + 1) / 2 != *n - 4) {
			fprintf(stderr, "zhookz(`PUT_RASTER'): Bad data\n");
			return;
		}
		put_raster(&raster);
		break;
	case GET_RECT:
		if(*m != 4)
			return;
		*m = 0;
		await_any_button_get_locator_2(FOREVER, 1, &butnum, &ax, &ay);
		if(butnum != 1)
			return;
		map_ndc_to_world_2(ax, ay, &y[0], &y[2]);
		move_abs_2(y[0], y[2]);
		set_echo_position(LOCATOR, 1, ax, ay);
		set_echo(LOCATOR, 1, 6);	/* 6 = rubber band box */
		await_any_button_get_locator_2(FOREVER, 1, &butnum, &bx, &by);
		if(butnum != 1)
			return;
		map_ndc_to_world_2(bx, by, &y[1], &y[3]);
		set_echo(LOCATOR, 1, 1);	/* 1 = pointing finger cursor */
		if(y[0] > y[1]) {		/* make xmin < xmax */
			t = y[0];
			y[0] = y[1];
			y[1] = t;
		}
		if(y[2] > y[3]) {		/* make ymin < ymax */
			t = y[3];
			y[3] = y[2];
			y[2] = t;
		}
		*m = 4;
		break;
	default:
		*m = 0;
	}
}

F77_SUB(zejecz)
{
	if(ask) {
		fprintf(stderr, "GO? ");
		while(getchar() != '\n') ;	/* ignore reply */
	}
	delete_all_retained_segments();
	create_retained_segment(nseg = 1);
}


F77_SUB(zflshz){}
F77_SUB(zintrz){}

F77_SUB(zwrapz)
{
	delete_all_retained_segments();
	deselect_view_surface(surface);
	terminate_view_surface(surface);
	terminate_device(LOCATOR, 1);
	terminate_core();
}

F77_SUB(zrdpnz, real=x, real=y, int=n, int=nmax)
{
	r_zrdpnz(F_REALP(x), F_REALP(y), F_INTP(n), F_INTP(nmax));
}

static r_zrdpnz(x, y, n, nmax)
float x[], y[];
long *n, *nmax;
{
	int but, i;
	float xin, yin;

	for(i = 0; i < *nmax; i++) {
		/* set_locator_2(1, xin, yin); */
		but = 0;
		while(but == 0)
			await_any_button_get_locator_2(FOREVER, 1, &but, &xin, &yin);
		if(but != 1)
			break;
		map_ndc_to_world_2(xin, yin, x++, y++);
		fprintf(stderr, "\07");
	}
	*n = i;
}

F77_SUB(amdiff, real=x, int=n)
{
	r_amdiff(F_REALP(x), F_INTP(n));
}

static r_amdiff(x, n) /* look for important parameter changes */
float x[];
long *n;
{
	static int styles[] = {SOLID, DOTTED, DASHED, DOTDASHED};
	static int nstyles = (sizeof(styles) / sizeof(*styles));
	int i, which, istyle;
	float value, fracx, fracy;
	double sin(), cos(), dvalue;
	int do_window = 0;

	for(i = 0; i < *n; i += 2) {
		which = x[i];
		value = x[i + 1];
		am(which) = value;
		switch(which) {

		case 8:
			istyle = (int)(value - 1) % nstyles;
			set_linestyle(styles[istyle]);
			break;

		case 9:
			set_linewidth((value - 1)/3);
			break;

		case 10:
			set_line_index((int)value);
			set_fill_index((int)value);
			set_text_index((int)value);
			break;

		case 14:
			dvalue = value * DEG2RD;
			set_charpath_2(cos(dvalue), sin(dvalue));
			dvalue += PI/2;
			set_charup_2(cos(dvalue), sin(dvalue));
			break;

		case 15:
			set_marker_symbol((char)value);
			break;

		case 40: /* plot in figure */
		case 41:
		case 42:
		case 43:
		case 44: /* figure on device */
		case 45:
		case 46:
		case 47:
		case 61: /* user coords */
		case 62:
		case 63:
		case 64:
		case 65: /* flag for clipping */
			do_window = 1;
			break;
		}
	}

	if(!do_window)
		return;

	/* close current segment to change viewport and window */
	close_retained_segment(nseg);
	if(do_window && am(65) > 0) {
		set_viewport_2(am(44), am(45), aspect*am(46), aspect*am(47));
		fracx = (am(62)-am(61)) / (am(41)-am(40));
		fracy = (am(64)-am(63)) / (am(43)-am(42));
		set_window(
			am(61) - am(40)*fracx,
			am(62) + (1 - am(41))*fracx,
			am(63) - am(42)*fracy,
			am(64) + (1 - am(43))*fracy);
	}
	if(do_window && am(65) <= 0) {
		fracx = am(45) - am(44);
		fracy = am(47) - am(46);
		set_viewport_2(
			am(44) + am(40)*fracx,
			am(44) + am(41)*fracx,
			(am(46) + am(42)*fracy)*aspect,
			(am(46) + am(43)*fracy)*aspect);
		set_window(am(61), am(62), am(63), am(64));
	}
	create_retained_segment(++nseg);
}

color_table(ndef, which, red, green, blue, setorget)
int ndef, setorget;
float which[], red[], green[], blue[];
{
	int i, j;

	for(i = 0; i < ndef; i++) {
		j = i + 1;
		while(j < ndef && which[j] == 1 + which[j-1])
			j++;
		j--;
		if(setorget == SET)
			define_color_indices(surface,
				(int)which[i], (int)which[j],
				&red[i], &green[i], &blue[i]);
		else
			inquire_color_indices(surface,
				(int)which[i], (int)which[j],
				&red[i], &green[i], &blue[i]);
		i = j;
	}
}


colorscreen(color_fd)
int color_fd;
{
	int color_num, bw_fd, bw_num, i;
	int color_neighbors[SCR_POSITIONS], bw_neighbors[SCR_POSITIONS];

	/*
	(void) signal(SIGWINCH, winch_catcher);
	strcpy(color.scr_fbname, "/dev/cgone0");
	colorpr = pr_open("/dev/cgone0");
	pr_getcolormap(colorpr, 0, 256, red, green, blue);
	color.scr_foreground.red = red[255];
	color.scr_foreground.green = green[255];
	color.scr_foreground.blue = blue[255];
	color.scr_background.red = red[0];
	color.scr_background.green = green[0];
	color.scr_background.blue = blue[0];
	color_fd = win_screennew(&color);
	*/
	color_num = win_fdtonumber(color_fd);
	bw_fd = open("/dev/win0", 0);
	if(bw_fd < 0)
		return(1);
	bw_num = win_fdtonumber(bw_fd);
	for(i = 0; i < SCR_POSITIONS; i++)
		color_neighbors[i] = bw_neighbors[i] = -1;
	bw_neighbors[colorpos] = color_num;
	color_neighbors[(2+colorpos)%4] = bw_num;
	win_setscreenpositions(color_fd, color_neighbors);
	win_setscreenpositions(bw_fd, bw_neighbors);
	close(bw_fd);
	return(0);
}

fill_am()
{
	double drw, drh, px, py, c1em, dev_width, dev_height;
	int i;

	for(i = 1; i <= 130; i++)
		am(i) = 0;

	/* device specific paramaters */
	am(20) = char_width * r.r_width;	/* char width in rasters */
	am(21) = char_height * r.r_height;	/* char height in rasters */
	am(22) = 0;  am(23) = r.r_width - 1;	/* x limits in rasters */
	am(24) = 0;  am(25) = r.r_height - 1;	/* y limits in rasters */
	am(26) = 0;  am(27) = 0;		/* char addressing offset */
	am(28) = am(29) = color ? 0.016 : 0.0125;/* raster size in inches */
	am(30) = color ? SUNCOLOR : SUNBW;	/* device code number (< 0)) */
	am(31) = 1;				/* allow char rotation */
	am(1) = 1;				/* allow char size change */

	/* fixed parameters, mainly from defltz.r */
	am(8) = 1;	am(9) = 1;	am(10) = 1;	am(11) = 1;
	am(15) = 42;	am(17) = 3;	am(18) = 1;	am(45) = 1;
	am(47) = 1;	am(49) = 1;	am(54) = 1;	am(57) = 5;
	am(58) = 5;	am(59) = 7;	am(60) = 126;	am(62) = 1;
	am(64) = 1;	am(66) = 0.02;	am(79) = -1;	am(80) = 1;
	am(81) = 1;	am(82) = 1;	am(83) = 1;	am(85) = 0.2;
	am(89) = 1;	am(91) = 1;	am(93) = 1;	am(94) = 1;
	am(97) = 109;	am(100) = 0.5;	am(101) = -1;	am(102) = 115;
	am(103) = 32;	am(105) = 1;	am(106) = 5;	am(107) = 115;
	am(108) = 32;	am(110) = 1;	am(111) = 5;	am(112) = 3;
	am(113) = 1;	am(119) = 111;	am(122) = 109;	am(130) = 0.001;

	/* dependencies, mainly from zzpltz.r, zscalz.r and zcsizz.r */
	drw = am(23) - am(22);
	drh = am(25) - am(24);
	am(70) = am(28);
	am(71) = am(29);
	am(74) = am(20) * am(28);
	am(75) = am(21) * am(29);
	c1em = max(am(74), am(75));
	am(50) = am(51) = am(52) = am(53) = 7 * c1em;
	am(123) = am(98) = drw * am(28);
	am(124) = am(99) = drh * am(29);
	am(40) = 7 * c1em / am(98);
	am(41) = 1 - am(40);
	am(42) = 7 * c1em / am(99);
	am(43) = 1 - am(42);
	px = am(41) - am(40);
	py = am(43) - am(42);
	am(76) = am(55) = am(98) * px;
	am(77) = am(56) = am(99) * py;
	am(32) = am(22) + am(40) * drw;
	am(33) = am(22) + am(41) * drw;
	am(34) = am(24) + am(42) * drh;
	am(35) = am(24) + am(43) * drh;
	am(36) = am(32);
	am(37) = px * drw;
	am(38) = am(34);
	am(39) = py * drh;
	am(67) = am(74) / am(76);
	am(68) = am(75) / am(77);
	am(72) = c1em / am(76);
	am(73) = c1em / am(77);
	am(84) = c1em / min(am(98),am(99));
}

F77_SUB(wclosz){}
F77_SUB(wcopyz){}
F77_SUB(wdiffz){}
F77_SUB(wejecz){}
F77_SUB(winitz){}
F77_SUB(wlinsz){}
F77_SUB(wpntsz){}
F77_SUB(wpolyz){}
F77_SUB(wsegsz){}
F77_SUB(wtextz){}
F77_SUB(wupdtz){}
F77_SUB(wwrapz){}
/*F77_MAIN (){}*/
