ROUTINE(plarcz,		plot circular or elliptical arcs)
subroutine plarcz(xc,yc,r,a1,a2)
INCLUDE(graphics)
real xx(20),yy(20)
data piby4/0.785398/
if (r<=0.) return
QUERY( rsz(rx,ry), smo(smo), uin(ux,uy), pin(pw,ph) )
scd = smo*amin1(rx,ry)
ri = amax1(ux,uy)*r
# heuristic - makes small circles more accurate
wgt = sqrt(amax1(0.1,ri/amin1(pw,ph)))
scd = wgt*scd
# 1-cos(dt/2) = scd/ri
# compute dt approximately by taylor series
dt = amax1(DEG2RD,amin1(piby4,4.*sqrt(scd/ri)))
t1 = amin1(a1,a2)*DEG2RD
t2 = amax1(a1,a2)*DEG2RD
i = 1
while (t2>t1) {
	xx(i) = xc+r*cos(t1)
	yy(i) = yc+r*sin(t1)
	i = i+1
	if (i>20) {
		call linesz(xx,yy,20)
		xx(1) = xx(20)
		yy(1) = yy(20)
		i = 2
		}
	t1 = t1+dt
	}
xx(i) = xc+r*cos(t2)
yy(i) = yc+r*sin(t2)
call linesz(xx,yy,i)
return
end
