#include "icdef.h"
dec() {
	/* returns:
	  -1: error
	   0: null
	 **1: name
	   2: missing type
	   3: missing right slash
	   4: null string
	 **5: name and type-specifier
	  *6: name =
	   7: missing type
	   8: missing right slash
	   9: null string
	 *10: name = type-specifier

	sets name, type, typeno, acount, attr;

	*legal arg declaration
	**legal declaration

	regular grammar:

                 string
	 name   / type  , ...   /
	0    1   2     3 2       5

                 string
	 name = / type  , ...   /
	0    1 6 7     8 7       10


	*/

#include "extern.h"
	int st, i, breakf;
	st=0;
	acount=0;
	typeno=0;
	while(token!=0) {
		usedf=1;
		switch(token) {
			case '+':
			case '"':
			case '`':
			case '.':
			case DIGIT:
			case 'e':
			case SPECIAL:
			case LETTER: switch(st) {
				case 0: if((state2=string())==1||state2==3||state2==5||state2==7||state2==8||state2==11) {
						st=1;
						for(i=0; i<NAMESIZE; i++){
							name[i]=text[i];
							if(name[i]==0) break;
							}
						break;
						}
					/* else */ return(st);
				case 2:
				case 7: if((state2=mstring(0,0))==0) {
						st++;
						for(i=0; i<ATTRSIZE; i++) {
							attr[acount][i]=text[i];
							if(text[i]==0) break;
							}
						if(++acount>=LISTSIZE) {
							acount--;
							fprintf(stderr,"ERROR: too many attributes\n");
							st= -1;
							}
						break;
						}
					/* else */ return(st);
				default: usedf=0; return(st);} break;
			case '/': switch(st) {
				case 1: st=2; BEGIN SSTATE; break;
				case 2:
				case 11:
				case 3: st=5; break;
				case 6: st=7; BEGIN SSTATE; break;
				case 7:
				case 16:
				case 8: st=10; break;
				default: usedf=0; return(st);
					} break;
			case TYPE: switch(st) {
				case 2:
				case 7: st++;
					BEGIN SSTATE;
					if(typeval==TS || typeval==ARRAY || typeval==MATRIX) {
						if(typeno==0)typeno=REAL;
						}
					else typeno=typeval;
					if(yyleng>=NAMESIZE) {
						fprintf(stderr, "SYSTEM ERROR (5) -- type too long\n");
						st= -1;
						}
					for(i=0; i<=yyleng; i++)
						type[i]=yytext[i];
					break;
				default: usedf=0; return(st);
				} break;
			case SPACE: /* in states where the program expects a single
					comma, SPACEs act like a comma.  If the
					token after the SPACEs is ',' or TYPE, the
					SPACEs are ignored
					*/
				usedf=0;
				while(token==SPACE) {
					switch(st) {
						case 2:
						case 3:
						case 7:
						case 8: BEGIN SSTATE;
						}
					token=yylex();
					}
				if(token==',' || token==TYPE) {
					break;
					}
				switch(st) {
					case 11:
					case 3:
					case 16:
					case 8: breakf=0; break;
					default: breakf=1;
					}
				if(breakf==1) break;
			case ',': switch(st) {
				case 3:
				case 8: st--;
					break;
				case 4:
				case 9: attr[acount][0]=0;
					if(++acount>=LISTSIZE) {
						acount--;
						fprintf(stderr,"ERROR: too many attributes\n");
						st= -1;
						}
					break;
				case 11: st=4; break;
					break;
				case 16: st=9; break;
				case 7:
				case 2: st+= 2; type[0]=0; typeno=STR;  break;
				default: usedf=0; return(st); } break;
			case '=': switch(st) {
				case 1: st=6; break;
				default: usedf=0; return(st);
					} break;
			default: usedf=0; return(st);
			} /* end of switch */
		if(usedf==1) {
			typeval=0;
			token=yylex();
			}
		usedf=0;
		} /* end of while */
	return(st);
	} /* end of function dec */
