ROUTINE(collap,		compute or remove margin from table)
#     algorithm as 51.1 appl. statist. (1972), vol 21, no 2
subroutine collap(nvar,x,y,locx,locy,nx,ny,dim,config,option)
#     if option is true, computes a marginal table from a complete
#     table.  if option is false, removes an effect from a table.
define(`MAXVAR',15)
integer size(incr(MAXVAR)),dim(nvar),config(nvar),coord(MAXVAR)
logical option
real x(nx),y(ny)	#the larger table is x and the smaller one is y
size(1) = 1	# initialize arrays
for(k=1; k<=nvar; k=k+1){
	l = config(k)
	if (l==0) break
	size(k+1) = size(k)*dim(l)
	}
n = k-1	# find number of variables in configuration
#     if marginal table desired, initialize y.  first cell of
#     marginal table is at y(locy) and table has size(k) elements
if (option) {
	locu = locy+size(k)-1
	do j = locy,locu
		y(j) = 0.0
	}
do k = 1,nvar	# initialize coordinates
	coord(k) = 0
i = locx
repeat {	# find locations in tables
	j = locy
	do k = 1,n {
		l = config(k)
		j = j+coord(l)*size(k)
		}
	if (option) y(j) = y(j)+x(i)
	else x(i) = x(i)-y(j)
	i = i+1
	do k = 1,nvar {	# update coordinates
		coord(k) = coord(k)+1
		if (coord(k)<dim(k)) next 2
		coord(k) = 0
		}
	break
	}
return
end
