ROUTINE(corssd,		correlations by SSD formula)
real function corssd(x,y,n,trm,scr)
integer n,ind(2),i
real x(1),y(1),trm,scr(n,2),v1,v2,trmean,trvar,xm,ym,xs,ys
if (n<=1) ERROR(too few points)
if (trm<0. | trm>=.5) ERROR(trimming parameter invalid)
ind(1) = trm*float(n)+1.
ind(2) = n-ind(1)+1
do i = 1,n {
	scr(i,1) = x(i)
	scr(i,2) = y(i)
	}
call psort(scr,n,ind,2)
call psort(scr(1,2),n,ind,2)
xm = trmean(scr,n,trm)
ym = trmean(scr(1,2),n,trm)
xs = sqrt(trvar(scr,n,trm))
ys = sqrt(trvar(scr(1,2),n,trm))
do i = 1,n {
	v1=x(i)/xs
	v2=y(i)/ys
	scr(i,2) = v1-v2
	scr(i,1) = v1+v2
	}
call psort(scr,n,ind,2)
v1 = trvar(scr,n,trm)
call psort(scr(1,2),n,ind,2)
v2 = trvar(scr(1,2),n,trm)
return( (v1-v2)/(v1+v2) )
end
