SUPPORT(qrce,		estimate condition number)
subroutine qrce(n,a,ia,cond,z)
# this subroutine provides an estimate of the condition
# number of a matrix which has first been reduced to
# triangular form using a qr decomposition
#
# input parameters
#
# n      order of the problem
# a      upper triangular matrix
# ia     row dimension of the a array as dimensioned in
#        the calling program
# output parameters
# cond   estimate of the condition number
# z      approximate null space of triangular matrix,
#        vector of length n (could be thought of as work space)
#
#   port routines called-sscal,saxpy,snrm2,sasum
integer ia,n
real a(ia,n),anorm,cond,z(n)
integer kb,kp1,j,k,i
real ek,sm,wk,sign,abs
real s,t,wkm,sasum,ynorm,snrm2
#
# compute the frobenius norm of the triangular matrix
#
#
anorm = 0.0
do i = 1,n
	anorm = amax1(anorm,snrm2(i,a(1,i),1))
#
# solve a(transpose)w = e
# where e is chosen to cause maximum local growth
# in the components of w
ek = 1.0
do j = 1,n
	z(j) = 0.0
do k = 1,n {
	if (abs(z(k))!=0.0)
		ek = sign(ek,-z(k))
	if (abs(ek-z(k))>abs(a(k,k))) {
		s = abs(a(k,k))/abs(ek-z(k))
		call sscal(n,s,z,1)
		ek = s*ek
		}
	wk = ek-z(k)
	wkm = -ek-z(k)
	s = abs(wk)
	sm = abs(wkm)
	if (a(k,k)==0.0) {
		wk = 1.0
		wkm = 1.0
		}
	else {
		wk = wk/a(k,k)
		wkm = wkm/a(k,k)
		}
	kp1 = k+1
	if (kp1<=n) {
		do j = kp1,n {
			sm = sm+abs(z(j)+wkm*a(k,j))
			z(j) = z(j)+wk*a(k,j)
			s = s+abs(z(j))
			}
		if (s<sm) {
			t = wkm-wk
			wk = wkm
			do j = kp1,n
				z(j) = z(j)+t*a(k,j)
			}
		}
	z(k) = wk
	}
s = 1.0/sasum(n,z,1)
call sscal(n,s,z,1)
ynorm = 1.0
#
#   solve u * z = w
do kb = 1,n {
	k = n+1-kb
	if (abs(z(k))>abs(a(k,k))) {
		s = abs(a(k,k))/abs(z(k))
		call sscal(n,s,z,1)
		ynorm = ynorm*s
		}
	if (a(k,k)!=0.0)
		z(k) = z(k)/a(k,k)
	else
		z(k) = 1.0
	t = -z(k)
	if (k!=1)
		call saxpy(k-1,t,a(1,k),1,z(1),1)
	}
#    make znorm = 1.0
s = 1.0/sasum(n,z,1)
call sscal(n,s,z,1)
ynorm = ynorm*s
#
#   set cond = estimate of the condition number of a
#
if (ynorm<=1.0)
	if (anorm>ynorm*R1MACH(2)) {
		cond = R1MACH(2)
		return
		}
cond = anorm/ynorm
return
end
