ROUTINE(rgamm, random gamma with shape eta)
real function rgamm(eta,iseed)
real eta; integer iseed
#     a pseudo-random gamma generator as presented by
#     j.w.frane and v.k. murthy in jasa (to appear in 1974)
#     the parameter  beta  is assumed to be 1.0 .

logical log
real x,y,a7,x0,q,p,x2,aold,c,a,vv
real runifs,rchis,rnormk
integer m,k,i,mm
SAVE( aold,a7,c,a,m,p,x2,q )
data aold/-1.0/
if(eta<=0.0) ERROR(eta less than or equal zero)
if (eta<0.5) {	
	if (eta!=aold) {
		aold = eta
		a7 = 2.0*eta
		x0 = a7**(1.0/(1.0-a7))
		c = x0-x0**a7
		a = 1.0/a7
		}
	repeat {
		y = rnormk(iseed)**2
		x = y**a
		}
		until(2.0*alog(runifs(iseed))<=x**a7-x+c)
	return( x*0.5 )
	}
if (eta!=aold) {	#     initialization for eta > 0.5
	aold = eta
	m = eta*2.0
	q = 2.0*eta-float(m)
	log = mod(m,2)!=0
	p = 1.0-q
	if (log) {	#computes sqrt(2)*gamma(del)/gamma(gam) for integer del.
		x2 = 0.3989423	#x2 = 1/sqrt( 2pi )
		k = eta-1.5
		if (k!=0)
			do i = 1,k
				x2 = x2*float(i+1)/(float(i)+0.5)
		}
	else {
#     computes sqrt(2)*gamma(del)/gamma(gam) for integer gam.
#     gam < eta < gam+1/2 = del
		x2 = 1.2533141
#     x2 = sqrt( pi/2 )
		k = eta-1.0
		if (k!=0)
			do i = 1,k
				x2 = x2*(float(i)+0.5)/float(i+1)
		}
	c = q/x2
	}
if (q==0.0)	#if exactly a chi-square, use one
	return( rchis(m,iseed)*0.5 )
repeat {	#draw from mixture of chi-squares
	mm = m
	if (runifs(iseed)>p)
		mm = mm+1
	vv = rchis(mm,iseed)
	y = sqrt(vv)
	}
	until(runifs(iseed)*(p+c*y)<=(y/x2)**q)
return( vv*0.5 )
end
