ROUTINE(trbak1,		back transform for eigenvectors)
subroutine trbak1(nm,n,a,e,m,z)
real a(nm,n),e(n),z(nm,m)
#     this subroutine is a translation of the algol procedure trbak1,
#     num. math. 11, 181-195(1968) by martin, reinsch, and wilkinson.
#     handbook for auto. comp., vol.ii-linear algebra, 212-226(1971).

integer i,j,k,l,m,n,nm
real s

#     this subroutine forms the eigenvectors of a real symmetric
#     matrix by back transforming those of the corresponding
#     symmetric tridiagonal matrix determined by  tred1.
#
#     on input-
#
#        nm must be set to the row dimension of two-dimensional
#          array parameters as declared in the calling program
#          dimension statement,
#
#        n is the order of the matrix,
#
#        a contains information about the orthogonal trans-
#          formations used in the reduction by  tred1
#          in its strict lower triangle,
#
#        e contains the subdiagonal elements of the tridiagonal
#          matrix in its last n-1 positions.  e(1) is arbitrary,
#
#        m is the number of eigenvectors to be back transformed,
#
#        z contains the eigenvectors to be back transformed
#          in its first m columns.
#
#     on output-
#
#        z contains the transformed eigenvectors
#          in its first m columns.
#
#     note that trbak1 preserves vector euclidean norms.
#
#     questions and comments should be directed to b. s. garbow,
#     applied mathematics division, argonne national laboratory
#
#     ------------------------------------------------------------------79445048
#
if (m!=0)
	if (n!=1)
#
		do i = 2,n {
			l = i-1
			if (e(i)!=0.0)
#
				do j = 1,m {
					s = 0.0
#
					do k = 1,l
						s = s+a(i,k)*z(k,j)
#     ********** divisor below is negative of h formed in tred1.
#                double division avoids possible underflow **********
					s = (s/a(i,l))/e(i)
#
					do k = 1,l
						z(k,j) = z(k,j)+s*a(i,k)
					}
			}
return
end



