/* code to initialize devices and turn them on or off */
#include <stdio.h>
#include "S.h"
#include "device.h"

static vector *dev_error()
{
	PROBLEM "Graphics attempted before device specified" RECOVER(NULL_ENTRY);
	return(S_void);
}

static vector * dev_null()
{
	return(S_void);
}

static float def_params[NPARAMS];
device deflt_device = {
	FALSE, 1, def_params, 0, NULL,
	{dev_null, dev_null, dev_null, dev_null, dev_error, dev_error,
	 dev_error, dev_error, dev_error, dev_error, dev_error, NULL,
	 dev_error, dev_error, dev_error, dev_error, dev_error, dev_error}
};

static device **all_devices = NULL;
device *cur_device = NULL;
static long device_number = 0, dev_allocated = 0;

extern float F77_COM(bgrp) [];


#define am(i)		F77_COM(bgrp)[(i)-1]
#define RASTERS		300	/* default rasters per inch */
#define POINTSIZE	14	/* default pointsize */
#define WIDTH	11	/* default page width in inches */
#define HEIGHT	8.5	/* default page height in inches */
device_init()
{
	long i; device *new_device();
	all_devices = PERMALLOC(10, device*);
	all_devices[0] = &deflt_device;
	device_number = 1; dev_allocated = 10;
	set_device(1L);
	for(i = 1; i <= 39; i++)
		am(i) = 0;
	am(20) = (POINTSIZE/72) * RASTERS * .65;	/* x character size */
	am(21) = (POINTSIZE/72) * RASTERS * 1.2;	/* y interline space */
	am(22) = 0;				/* x limits */
	am(23) = WIDTH * RASTERS;
	am(24) = 0;				/* y limits */
	am(25) = HEIGHT * RASTERS;
	am(28) = 1.0 / RASTERS;		/* raster size in inches */
	am(29) = am(28);
	am(30) = 0;			/* some number */
	am(31) = 1;				/* characters rotate */
	am(1) = 1;				/* characters scale */
	F77_SUB(defltz)();			/* set other parameters */
	/*gr_reset((float *)NULL);*/
}

device *new_device(d_template, which)
device *d_template; long which;
{
	device *d; long prev;
	if(which==0)which = ++device_number;
	else if(which>device_number || which<0)
		PROBLEM "Invalid device number %ld", which RECOVER(NULL_ENTRY);
	else { /* replace existing device of this number */
		d = all_devices[which-1]; free((char *)d->params);
		free((char *)d->local_params); free((char *)d);
	}
	d = PERMALLOC(1, device);
	*d = *d_template;
	d->params = PERMALLOC(NPARAMS, float);
	d->local_params = (char *)PERMALLOC(d->nlocal, long);
	if(device_number >= dev_allocated ) {
		prev = set_alloc(0L); /* permanent storage */
		if(dev_allocated) {
			dev_allocated *= 2;
			all_devices = (device **)S_realloc((char *)all_devices,dev_allocated,device_number,sizeof(device *));
		}
		else {
			dev_allocated = 10;
			all_devices = (device **)S_alloc(dev_allocated,sizeof(device *));
		}
		set_alloc(prev);
	}
	all_devices[which-1] = d;
	d->which = which;
	return(d);
}

set_device(n)
long n;
{
	extern float F77_COM(bgrp) [];
	device *d; char *enci1();
	float *from , *to ;
	d = all_devices[n-1];
	if(d == NULL)
		PROBLEM "Graphics device %ld doesn't exist", n RECOVER(NULL_ENTRY);
	if(cur_device == d)return; /* already on */
	if(cur_device != (device *)NULL) { /* save the current parameters */
		from = F77_COM(bgrp); to = cur_device->params;
		n=NPARAMS; while(n--)*to++ = *from++;
		/* following line would not be needed if multiple devices allowed*/
		cur_device->active = FALSE;
	}
	cur_device = d;
	from = d->params; to = F77_COM(bgrp);
	n=NPARAMS; while(n--)*to++ = *from++;
	d->active = TRUE;
}

gr_wrap()
{
	long n = device_number; device *p, **all = all_devices;
	while(n--) {
		p = *all++;
		if(p && p->active && p->routines[DEV_wrap])
			(*(p->routines[DEV_wrap]))();
	}
	set_device(1L); /*  restore the default device */
}

extern int in_graphics;

F77_SUB(zerrpz) (code, msg)
F_CHARTYPE code, msg;
{
	PROBLEM "Graphics error: %s (in %s)",
		F_CHARP(msg), F_CHARP(code) WARNING(NULL_ENTRY);
}

/* map user menu function to device's menu if any */
vector *S_menu(ent, arglist)
vector *ent, *arglist;
{
	vector *value, **args; int graphics;
	long n, menu(); extern device *cur_device;
	args = arglist->value.tree;
	graphics = arglist->length > 1 && logical_value(args[1],ent);
	if( cur_device!=NULL_DEVICE && cur_device->active &&
	  (cur_device->routines[DEV_menu]!=NULL) && graphics)
		return( (*(cur_device->routines[DEV_menu])) (ent, arglist));
	value = coevec(*(arglist->value.tree),ANY,TRUE,CHECK_IT);
	if(value==NULL_ENTRY)return(S_void);
	value = coevec(value,CHAR,TRUE,CHECK_IT);
	n=menu(value->value.Char,value->length);
	value=alcvec(INT,1L); *(value->value.Long) = n;
	return(value);
}
