#include <stdio.h>
#include "ppm.h"
#include "ppmdraw.h"
#include "font.c"

static pixel** pixels;

pixel dark_red;
pixel red;
pixel blue;
pixel dark_blue;
pixel p;

void draw_text(int x, int y, char *s);
void draw_text_up(int x, int y, char *s);

void norm_proc (pixel** pixels, int cols, int rows, 
	pixval maxval, int x, int y, char* clientdata) {
	if ((x<0) || (x>=cols) || (y<0) || (y>=rows)) {
		return;
	}
	pixels[y][x] = *((pixel*)clientdata);
}

void dashed_proc (pixel** pixels, int cols, int rows, 
	pixval maxval, int x, int y, char* clientdata) {
	static int count = 0;
	count++;
	if (count == 8) {
		count = 0;
	}
	if ((x<0) || (x>=cols) || (y<0) || (y>=rows)) {
		return;
	}
	if (count<4) {
		pixels[y][x] = *((pixel*)clientdata);
	}
}

int cols;
int rows;

int inbounds(int x, int y) {
	if (((x<0) || (x>=cols)) || ((y<0) || (y>=rows))) {
		return 0;
	}
	return 1;
}

main(int argc, char *argv[]) {
	pixval maxval;
	int i;
	int dashed = 0;
	void (*dproc)(pixel**, int, int, pixval, int, int, char*) = norm_proc;
	pixels = ppm_readppm(stdin, &cols, &rows, &maxval);
	PPM_ASSIGN(dark_red, 192, 0, 10);
	PPM_ASSIGN(red, 255, 0, 0);
	PPM_ASSIGN(blue, 175, 175, 255);
	PPM_ASSIGN(dark_blue, 0, 0, 255);
	p = red;
	i = 1;
	while (i<argc) {
		if (strncmp(argv[i], "-d", 2) == 0) {
			p = dark_red;
			dashed = 1;
			dproc = dashed_proc;
			i++;
		} else if (strncmp(argv[i], "-n", 2) == 0) {
			p = red;
			dashed = 0;
			i++;
			dproc = norm_proc;
		} else if (strncmp(argv[i], "-tu", 3) == 0) {
			draw_text_up(atoi(argv[i+1]), atoi(argv[i+2]), argv[i+3]);
			i+=4;
		} else if (strncmp(argv[i], "-t", 2) == 0) {
			draw_text(atoi(argv[i+1]), atoi(argv[i+2]), argv[i+3]);
			i+=4;
		} else {
			ppmd_line(pixels, cols, rows, maxval, atoi(argv[i]), atoi(argv[i+1]),
				atoi(argv[i+2]), atoi(argv[i+3]), dproc, (void*)&p);
			i+=4;
		}
	}
	ppm_writeppm(stdout, pixels, cols, rows, maxval, 0);	 
}

#define PPM_AVG(p) ((PPM_GETR(p) + PPM_GETG(p) + PPM_GETB(p)) / 3)

float avg_level(int x, int y, int w, int h) {
	float total = 0;
	int r, c;
	int count = 0;
	for (r = 0; (r<h); r++) {
		for (c = 0; (c<w); c++) {
			int xp = x+c;
			int yp = y+r;
			if (inbounds(xp, yp)) {
				total += PPM_AVG(pixels[yp][xp]);
				count++;
			}
		}
	}
	return total/count;
}

void draw_text(int x, int y, char *s) {
	int r, c, i;
	int level;
	pixel p;
	int alevel;
	alevel = avg_level(x, y, 8*strlen(s), 16);
	if (alevel > 128) {
		p = dark_blue;
	} else {
		p = blue;
	}
	for (i=0; (i<strlen(s)); i++) {
		int ch = s[i]-32;
		if ((ch < 0) || (ch > 95)) {
			ch = 0;
		}
		for (r = 0; (r<16); r++) {
			for (c = 0; (c<8); c++) {
				int xp = x+c+i*8;
				int yp = y+r;
				if (inbounds(xp, yp) && font[ch][r][c]) {
					int alevel;
					alevel = PPM_AVG(pixels[yp][xp]);
					if (alevel > 128) {
						p = dark_blue;
					} else {
						p = blue;
					}
					pixels[yp][xp] = p;
				}
			}
		}
	}
}

void draw_text_up(int x, int y, char *s) {
	int r, c, i;
	pixel p;
	if (avg_level(x, y, 8*strlen(s), 16) > 128) {
		p = dark_blue;
	} else {
		p = blue;
	}
	for (i=0; (i<strlen(s)); i++) {
		int ch = s[i]-32;
		if ((ch < 0) || (ch > 95)) {
			ch = 0;
		}
		for (r = 0; (r<16); r++) {
			for (c = 0; (c<8); c++) {
				int xp = x+r;
				int yp = y-c-i*8;
				if (inbounds(xp, yp) && font[ch][r][c]) {
					int alevel;
					alevel = PPM_AVG(pixels[yp][xp]);
					if (alevel > 128) {
						p = dark_blue;
					} else {
						p = blue;
					}
					pixels[yp][xp] = p;
				}
			}
		}
	}
}
