/* $Id: propagate.c,v 1.1 1996/04/11 03:28:49 bert Exp $
 *
 * propagate a 2-dimensional wave packet
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include "complex.h"
#include "fft.h"


/** ugly macros for tracking execution progress **/

#ifdef DO_TRACK_SYNC
#define TRACK(fd, foo...)  fprintf(fd, ## foo); fflush(fd)
#else
#ifdef DO_TRACK
#define TRACK(fd, foo...)  fprintf(fd, ## foo)
#else
#define TRACK(fd, foo...)
#endif /* DO_TRACK */
#endif /* DO_TRACK_SYNC */

/***** code *****/

/*
 * time-propagates a packet, using given parameters.
 *   data --                 packet.
 *   propV2, propV, propK -- propagator coefficient matrices.
 *   size --                 size for packet and propagators.
 *   niter --                number of iterations.
 *   offset --               "offset" for iteration numbering.
 */
void propagate (complex *data, complex *propV2, complex *propV, complex *propK,
		unsigned long size, unsigned long niter, unsigned long offset)
{
  unsigned long i,j,k;

  /*** start by applying  exp(V/2) ***/

  for (j=0;j<size;j++)
    for (k=0;k<size;k++) {
      data[k+j*size] *= propV2[k+j*size];
    }

  /*** iterate doing exp(K)exp(V) ***/

  for (i = (1+offset); i < (niter+offset); i++) {
    TRACK(stdout,"[%ld",i);
    fft2((real*)data,size,1);   /* fft2 takes reals, that's OK */
    TRACK(stdout,"p");


    /* apply exp(K) */
    for (j=0;j<size;j++)
      for (k=0;k<size;k++) {
	data[k+j*size] *= propK[k+j*size];
      }

    TRACK(stdout,"K");
    fft2((real*)data,size,-1);  /* fft2 takes reals, that's OK */
    TRACK(stdout,"s");

    /* apply exp(V) */
    for (j=0;j<size;j++)
      for (k=0;k<size;k++) {
	data[k+j*size] *= propV[k+j*size]/(size*size);
      }
    TRACK(stdout,"V] ");
  }

  /*** final exp(K)exp(V/2) ***/

  TRACK(stdout,"[%ld",i);
  fft2((real*)data,size,1);   /* fft2 takes reals, that's OK */
  TRACK(stdout,"p");

  /* apply exp(K) */
  for (j=0;j<size;j++)
    for (k=0;k<size;k++) {
      data[k+j*size] *= propK[k+j*size];
    }

  TRACK(stdout,"K");
  fft2((real*)data,size,-1);  /* fft2 takes reals, that's OK */
  TRACK(stdout,"s");

  /* apply exp(V/2) */
  for (j=0;j<size;j++)
    for (k=0;k<size;k++) {
      data[k+j*size] *= propV2[k+j*size]/(size*size);
    }

  TRACK(stdout,"V/2].");
}
