/* $Id: expect.c,v 1.2 1996/04/11 03:15:49 bert Exp $
 * calculation of probabilities and expectation values
 */

#include "complex.h"
#include "expect.h"

/** code **/

/*
 * calculate <x> of a packet
 *
 * arguments:
 *   K --       packet.
 *   n --       dimension of matrix.  (must be a power of 2 because of FFT.)
 *   delta --   discrete space step.
 */
real expect_X (complex *pack, long n, double delta)
{
  long i,ii,ni,k,nk;

  real result = 0.;

  /* it's easiest to do positives and negatives together. */
  for (i=0,ii=0,ni=0; ii<=ni; i++,ii+=n,ni=(n*n)-ii) {
    for (k=0,nk=0; k<=nk; k++,nk=n-k) {
      if (ni) {
	if (nk)
	  result += i * ( csqabs( pack[ii+k] ) + csqabs( pack[ii+nk] )
			 - csqabs( pack[ni+k] ) - csqabs( pack[ni+nk] ) );
	else
	  result += i * ( csqabs( pack[ii+k] ) - csqabs( pack[ni+k] ) );
      }
      /* if ni=0, then i=0, so contribution is 0 */
    }
  }
  return (delta*result);
}

/*
 * calculate <y> of a packet
 *
 * arguments:
 *   K --       packet.
 *   n --       dimension of matrix.  (must be a power of 2 because of FFT.)
 *   delta --   discrete space step.
 */
real expect_Y (complex *pack, long n, double delta)
{
  long i,ii,ni,k,nk;

  real result = 0.;

  /* it's easiest to do positives and negatives together. */
  for (i=0,ii=0,ni=0; ii<=ni; i++,ii+=n,ni=(n*n)-ii) {
    for (k=0,nk=0; k<=nk; k++,nk=n-k) {
      if (nk) {
	if (ni)
	  result += k * ( csqabs( pack[ii+k] ) - csqabs( pack[ii+nk] )
			 + csqabs( pack[ni+k] ) - csqabs( pack[ni+nk] ) );
	else
	  result += k * ( csqabs( pack[ii+k] ) - csqabs( pack[ii+nk] ) );
      }
      /* if nk=0, then k=0, so contribution is 0 */

    }
  }
  return (delta*result);
}


/*
 * calculate sum of squares of the matrix elements (total probability).
 *   A --    data.  (n x n array)
 *   n --    array size.
 */
real sum_sq(complex *A, long n)
{
  long i,j;
  real sum=0.l;

  for (i=0; i<(n*n); i+=n)
    for (j=0; j<n; j++)
      sum += csqabs(A[i+j]);

  return sum;
}

/*
 * calculate overlap of two wave packets.
 *   A --    first packet.  (n x n array)
 *   B --    second packet.  (n x n array)
 *   n --    array size.
 */
complex overlap(complex *A, complex *B, long n)
{
  long i,j;
  real sum=0.l;

  for (i=0; i<(n*n); i+=n)
    for (j=0; j<n; j++)
      sum += ((~A[i+j])*(B[i+j]));

  return sum;
}
