/* $Id: complex.c,v 1.4 1997/06/09 17:48:36 bert Exp $
 *
 * testing... testing... one, two, three...
 *
 */

#define _COMPLEX_C  /* part of a gross hack */
#include "complex.h"
#include <math.h>

/*
 *   exponential of a complex number.
 */
INLINE
complex cexp(complex z)
{
  return exp(Re(z)) * (cos(Im(z)) + 1i*sin(Im(z)));
}

/*
 *   return (real) absolute value of a complex number.
 */
INLINE
real cabs(complex z)
{
  /* C has no power operator, and it's silly to call pow() for squaring... */
  return sqrt((Re(z)*Re(z)) + (Im(z)*Im(z)));
}

/*
 *   return square of (real) absolute value of a complex number.
 */
INLINE
real csqabs(complex z)
{
  /* C has no power operator, and it's silly to call pow() for squaring... */
  return (Re(z)*Re(z)) + (Im(z)*Im(z));
}

/*
 *   return one of two square roots of a complex number.
 *   we choose to return the value with positive real part.
 */
INLINE
complex csqrt(complex z)
{
  real abq = sqrt((Re(z)*Re(z)) + (Im(z)*Im(z)));   /* see above */

  if (Im(z)>=0) {
    return sqrt((abq+Re(z))/2) + 1i * sqrt((abq-Re(z))/2);
  } else {
    return sqrt((abq+Re(z))/2) - 1i * sqrt((abq-Re(z))/2);
  }
}

/*
 *   return the argument (ie, "angle") of a complex number.
 */
INLINE
real carg(complex z)
{
  return atan2(Im(z), Re(z));
}
