
#include "complex.h"
#include "oppack.h"

/** I love spaghetti. **/

#define square(a)   ((a)*(a))

/** global variables **/

real hbar = .05l;
real mass = 1.l;

/** code **/

/*
 * generate matrix of coefficients for potential part of propagator [harmonic]
 *
 * arguments:
 *   V --     array for return matrix.
 *              (must be already allocated and be at least n*n big.)
 *   n --     dimension of matrix.  (must be a power of 2 because of FFT.)
 *   delta -- discrete space step.
 *   vcoef -- constant multiplier for the potential.
 * Last three aren't long double because of compiler bugs.
 */
void generate_V_harmonic (real *V, long n,
			  double delta, double vcoef, double mu)
{
  long i,ii,ni,k,nk,i2;

  real arg;
  real mult = (real)delta*delta*vcoef;

  /* it's easiest to do positives and negatives together. */
  /* (we don't realy care about +/- nhalf overlap.) */
  for (i=0,ii=0,ni=0; ii<=ni; i++,ii+=n,ni=(n*n)-ii) {
    i2 =i*i;       /* precalculate */
    for (k=0,nk=0; k<=nk; k++,nk=n-k) {
      /* r^2 = (i^2+k^2)*delta^2 */
      /* (exp(-i*V*dt/hbar))ik = exp(-i*(vcoef*r^2)*dt/hbar) */
      arg = (i2+k*k)*mult;
      V[ii+k] = V[ii+nk] = V[ni+k] = V[ni+nk] = (arg);
    }
  }
}

/*
 * generate matrix of coefficients for potential part of propagator [Nelson]
 *
 * arguments:
 *   V --     array for return matrix.
 *              (must be already allocated and be at least n*n big.)
 *   n --     dimension of matrix.  (must be a power of 2 because of FFT.)
 *   dt --    discrete time step.
 *   delta -- discrete space step.
 *   vcoef -- constant multiplier for the potential.
 *   mu --    coefficient of the x^2 term
 * Last four aren't long double because of compiler bugs.
 */
void generate_V_nelson (real *V, long n,
			double delta, double vcoef, double mu)
{
  long i,ii,ni,k,nk,i2;

  real arg;
  real mult = (real)delta*delta*vcoef;

  /* it's easiest to do positives and negatives together. */
         /* (only for x, in this case...) */
  /* (we don't realy care about +/- nhalf overlap.) */
  for (i=0,ii=0,ni=0; ii<=ni; i++,ii+=n,ni=(n*n)-ii) {
    i2 =i*i;       /* precalculate */
    for (k=0,nk=0; k<=nk; k++,nk=n-k) {
      /* V = mu*x^2/2 + (y - x^2/2)^2 = */
      /*   = delta^2 [mu*i^2/2 + (k - delta*i^2/2)^2] */
      /* Vprop[i,k] = (exp(-i*V[i,k]*dt/hbar)) */
      arg = (k - delta*i2/2.);
      arg = (mu*i2/2.+arg*arg)*mult;
      V[ii+k] = V[ni+k] = (arg);
      arg = (-k - delta*i2/2.);
      arg = (mu*i2/2.+arg*arg)*mult;
      V[ii+nk] = V[ni+nk] = (arg);
    }
  }
}

/*
 * generate matrix of coefficients for potential part of propagator [constant]
 *
 * arguments:
 *   V --     array for return matrix.
 *              (must be already allocated and be at least n*n big.)
 *   n --     dimension of matrix.  (must be a power of 2 because of FFT.)
 *   delta -- discrete space step.
 *   vcoef -- constant multiplier for the potential.
 * Last three aren't long double because of compiler bugs.
 */
void generate_V_constant (real *V, long n,
			  double delta, double vcoef, double mu)
{
  long i,k;

  /* (exp(-i*V*dt/hbar)) */
  real arg = (real)vcoef;
  real val = (arg);

  for (i=0; i<(n*n); i+=n) {
    for (k=0; k<n; k++) {
      V[i+k] = val;
    }
  }
}

/*
 * generate matrix of coefficients for kinetic part of propagator
 *
 * arguments:
 *   K --       array for return matrix.
 *                (must be already allocated and be at least n*n big.)
 *   n --       dimension of matrix.  (must be a power of 2 because of FFT.)
 *   delta --   discrete space step.
 * Last two aren't long double because of compiler bugs.
 */
void generate_K (real *K, long n, double delta)
{
  long i,ii,ni,k,nk,i2;

  real arg;
  real mult = (real)M_PI/(n*delta);
  mult = dt*2*hbar*hbar*mult*mult/mass;

  /* it's easiest to do positives and negatives together. */
  /* (we don't realy care about +/- nhalf overlap.) */
  for (i=0,ii=0,ni=0; ii<=ni; i++,ii+=n,ni=(n*n)-ii) {
    i2 =i*i;       /* precalculate */
    for (k=0,nk=0; k<=nk; k++,nk=n-k) {
      /* p^2 = (i^2+k^2)*(2*pi*hbar/N/delta)^2 */
      /* (exp(-i*K*dt/hbar))ik = exp(-i*(p^2/2/m)*dt/hbar) */
      arg = (i2+k*k)*mult;
      K[ii+k] = K[ii+nk] = K[ni+k] = K[ni+nk] = (arg);
    }
  }
}

int main(int argc, char **argv)
{
