/* $Id: complex.h,v 1.4 1997/06/09 17:24:09 bert Exp $
 *
 * directives for making complex numbers work in C
 * (currently works only with GCC)
 *
 */

#ifndef _COMPLEX_H
#define _COMPLEX_H

/* a "sanitized" math.h */

#include "mmath.h"

/* GNUC check and typedefs */

#ifdef __GNUC__

#ifdef SHORT
typedef   float                    real;      /* -DSHORT (float) */
typedef   __complex__ float        complex;
#define LFMT
#else
#ifndef LONG
typedef   double                    real;     /* no -D  (double) */
typedef   __complex__ double        complex;
#define LFMT
#else
typedef   long double               real;     /* -DLONG (long double) */
typedef   __complex__ long double   complex;
#define LFMT "L"
#endif
#endif

#define Re(z)    __real__ (z)
#define Im(z)    __imag__ (z)

#else
#error Sorry, I need a compiler that supports complex numbers. (Try gcc.)
#endif

/* This is ugly... but it's useful.  Go away. */

#ifdef INLINING

#define INLINE static
#ifndef _COMPLEX_C
#include "complex.c"
#endif

#else
/* prototypes for complex.c */

#define INLINE
complex cexp(complex);
real    cabs(complex);
real    csqabs(complex);
complex csqrt(complex);
real    carg(complex);

#endif /* INLINING */


#endif
