/* $Id$
 *
 * testing... testing... one, two, three...
 *
 */

#include "complex.h"
#include <stdio.h>

void main()
{
  complex eep = M_PI*1.0li;
  complex foo;
  complex bar;
  int i;

  printf("DATA TYPE SIZES:\n");
  printf("  float:                   %d\n",  sizeof(float));
  printf("  double:                  %d\n",  sizeof(double));
  printf("  long double:             %d\n\n",sizeof(long double));
  printf("  __complex__ float:       %d\n",  sizeof(__complex__ float));
  printf("  __complex__ double:      %d\n",  sizeof(__complex__ double));
  printf("  __complex__ long double: %d\n\n",sizeof(__complex__ long double));
  printf("  complex:                 %d\n\n",sizeof(complex));

  printf("FUNCTIONS:\n");
  foo = cexp(0);
  printf("  exp(0) =    %" LFMT "f%+" LFMT "fi\n", Re(foo), Im(foo));
  printf("  -i pi =     %" LFMT "f%+" LFMT "fi\n", Re(~eep), Im(~eep));

  foo = cexp(eep);
  printf("  exp(i pi) = %" LFMT "f%+" LFMT "fi\n", Re(foo), Im(foo));

  foo = cexp(1+1li);
  printf("  exp(i) =    %" LFMT "f%+" LFMT "fi\n", Re(foo), Im(foo));
  printf("  exp(i)* =   %" LFMT "f%+" LFMT "fi\n", Re(~foo), Im(~foo));


  foo=eep/3;
  foo=cexp(foo);
  bar=1.0;

  printf("\nROTATION:\n");
  for (i=0; i<=6; i++) {
    printf("  %2d  %" LFMT "f%+" LFMT "fi\n", i, Re(bar), Im(bar));
    bar = (foo*bar);
  }

  foo=eep/4;
  foo=sqrt(2)*cexp(foo);
  bar=1;

  printf("\nSPINNING TRIANGLES:\n");
  for (i=0; i<=6; i++) {
    printf("  %2d  %" LFMT "f%+" LFMT "fi\n", i, Re(bar), Im(bar));
    bar = (foo*bar);
  }

  bar=-2;

  printf("\nROOTS:\n");
  for (i=0; i<=6; i++) {
    printf("  %2d  %" LFMT "f%+" LFMT "fi  [%" LFMT "f]\n", i, Re(bar),Im(bar),
	   cabs(bar));
    bar = csqrt(bar);
  }

}
