/* $Id: util.c,v 1.3 1995/07/13 17:24:04 bert Exp $
 * random helper functions
 */

#include <malloc.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include "complex.h"
#include "util.h"

char* progname;  /* name we're running under */

/*
 * allocate memory (and check that we actually got some)
 *   size -- number of bytes to allocate.
 *   info -- documentation for error message.
 */
void *safe_malloc(size_t size, char* info)
{
  void *ret = (void*)malloc(size);
  if (ret==(void*)NULL) {
    fprintf(stderr,"%s: malloc(%s) failed [%s]\n",
	    progname, info ? info : "", strerror(errno));
    exit(255);
  }
  return ret;
}


/*
 * save real parts from a complex array to a file in ASCII form
 *   A --    data.  (n x n array)
 *   n --    array size.
 *   file -- output file name.
 */
void dump_Re(complex *A, long n, char* file)
{
  long i,j;
  FILE *ff;

  ff = fopen (file, "w");
  if (ff==(FILE*)NULL) {
    fprintf(stderr,"%s: can't open %s for writing [%s]\n",
	    progname, file, strerror(errno));
    exit(99);
  }

  for (i=0; i<n; i++) {
    for (j=0; j<n; j++) {
      fprintf(ff, " %20.16" LFMT "e", Re(A[i*n+j]));
    }
    fprintf(ff, "\n");
  }

  fclose(ff);
}


/*
 * save imaginary parts from a complex array to a file in ASCII form
 *   A --    data.  (n x n array)
 *   n --    array size.
 *   file -- output file name.
 */
void dump_Im(complex *A, long n, char* file)
{
  long i,j;
  FILE *ff;

  ff = fopen (file, "w");
  if (ff==(FILE*)NULL) {
    fprintf(stderr,"%s: can't open %s for writing [%s]\n",
	    progname, file, strerror(errno));
    exit(99);
  }

  for (i=0; i<n; i++) {
    for (j=0; j<n; j++) {
      fprintf(ff, " %20.16" LFMT "e", Im(A[i*n+j]));
    }
    fprintf(ff, "\n");
  }

  fclose(ff);
}
