/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#ifndef _ENV_INC
#define _ENV_INC

#include "obj.h"
#include "sym.h"

#define ENVM_CHUNK 8

typedef struct envm_s {
  LLSym *name;
  LLObj *value;
} LLEnvm;

typedef struct env_s {
  LLIS_OBJECT;
  struct env_s *parent;
  LLEnvm *members;
  int num_members;
  int alloced_members;
} LLEnv; 

LLTag llenv_t;			/* Environment magic number */
extern LLEnv *tlge;		/* The Limey global environment */
extern LLEnv *root;		/* The root environment -- includes
				   special system objects that need
				   protection from the garbage 
				   collector */

#define llcget_parent(env) ((env)->parent)

LLEnv *llmake_child_env();	/* Give it a parent */
LLObj *llget_env();		/* Look up object in environment using arg stack */
LLObj *get_env();		/* Look up object in environment (C function call) */
void llinit_env();

#endif

