/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#ifndef _VECTOR_INC
#define _VECTOR_INC

#include "obj.h"

typedef struct Vector_s {
  LLIS_OBJECT;
  LLObj **vector; 
  long size; 
} LLVector;

extern LLTag llvector_t;	/* Magic number for vectors */

#define llcvector_ref(vec, ref) ((vec)->vector[ref])
#define llcvector_length(vec) ((vec)->size)

void llinit_vector();
LLVector *llcmake_vector();

#endif 
