/*
 * fc.c - Freecell main module.
 * 
 * Copyright (C) 1994, George A. Madrid
 */

#include <stdlib.h>
#include <string.h>

#include "err.h"
#include "fc.h"

#include "card.h"

#include <signal.h>
#include <sys/types.h>
#include <sys/time.h>
#include <errno.h>
#include <unistd.h>

/* ---------- Globals ---------- */
struct world gworld;
char *whoami = NULL;
char *dpyname = NULL;
Display *dpy = NULL;
int done = 0;
XTextProperty gameTextProp;
XTextProperty gameIconProp;
char gameName[100];
int is_color = FALSE;
int round_cards = TRUE;

/* ---------- Arg stuff ---------- */
char *win_back_color = "Sea Green"; /* Default backcolor */

/* ---------- Function declarations ---------- */
static void init(struct world *, int, char **);
static void do_it(struct world *);
static void term(struct world *);
static void usage(void);

/* ---------------------------------------------------------------------- */
int
main(int argc, char **argv)
{
     init(&gworld, argc, argv);
     do_it(&gworld);
     term(&gworld);
     return(0);
}

/* ---------------------------------------------------------------------- */
static void
init(struct world *world, int argc, char **argv)
{
     Colormap cmap;
     XColor color;
     int i;
     struct wind_params wp;

     /* Deal with args */
     whoami = ((whoami = strrchr(argv[0], '/')) ? whoami++ : argv[0]);
     for (i = 1; i < argc; i++) {
	  if (argv[i][0] == '-') {
	       switch(argv[i][1]) {
		  case 'c':
		    /* New background color */
		    win_back_color = argv[++i];
		    break;
		  default:
		    usage();
		    break;
	       }
	  }
	  else {
	       usage();
	  }
     }

     if (!(dpy = XOpenDisplay(dpyname))) {
	  do_error(ERR_NODISPLAY, "Can't open display.\n");
     }

     /* Are we color? */
     if (DisplayCells(dpy, DefaultScreen(dpy)) > 2)	{
	  is_color = True;
     } else {
	  is_color = False;
     }

     {
	  char hostname[64];
	  char *user = (char *)getenv("USER");
	  gethostname(hostname, 64);
	  sprintf(gameName, "Freecell: %s@%s",
		  user ? user : "anonymous",
		  hostname);
	  gameTextProp.value = (unsigned char *)gameName;
	  gameTextProp.encoding = XA_STRING;
	  gameTextProp.format = 8;
	  gameTextProp.nitems = strlen(gameName);

	  gameIconProp.value = (unsigned char *)"Freecell";
	  gameIconProp.encoding = XA_STRING;
	  gameIconProp.format = 8;
	  gameIconProp.nitems = strlen(gameIconProp.value);
     }
     
     wp.win_type = FC_WINDOW;
     wp.x = INIT_X;
     wp.y = INIT_Y;
     wp.width = INIT_WIDTH;
     wp.height = INIT_HEIGHT;
     wp.gc = DefaultGC(dpy, DefaultScreen(dpy));
     if (is_color) {
	  cmap = DefaultColormap(dpy, DefaultScreen(dpy));
	  /* Silent failure !!! */
	  XParseColor(dpy, cmap, win_back_color, &color);
	  color.flags = DoRed | DoGreen | DoBlue;
	  XAllocColor(dpy, cmap, &color);
	  wp.bck_color = color.pixel;
     }
     else {
	  wp.bck_color = 0;
     }
     world->window = wind_create(NULL, &wp);
     gfx_init(dpy, DefaultScreen(dpy), wind_syswin(world->window));
}

/* ---------------------------------------------------------------------- */
static void
do_it(struct world *world)
{
     XEvent xev;
     
     while (!done) {
	  XNextEvent(dpy, &xev);
	  do_event((XAnyEvent *)&xev);
     }
}

/* ---------------------------------------------------------------------- */
static void
term(struct world *world)
{
     wind_destroy(world->window);
     XCloseDisplay(dpy);
}

/* ---------------------------------------------------------------------- */
static void
usage()
{
     return;
}

