#!/bin/sh
#
#   Interpret the toba.Lister program
#
#   Copyright 1996, 1997 Arizona Board of Regents; see COPYRIGHT file for 
#   details.

JAVA=${JAVA-java}

# return the full path of an executable
whereis() {
   # get the path
   ret=`type $* | sed -e 's#[()]##g'	\
                      -e 's#^.* ##g'`

   # make it absolute
   case $ret in
      /*) ;;
      *)  ret=`pwd`/$ret;;
   esac

   # eliminate . and .. components
   echo $ret | sed -e 's#/\./#/#g'	\
		   -e 's#/[^/][^./]*/\.\./#/#g'
}



# deduce current directory
PROG=`whereis $0`
TOP=`echo $PROG | sed 's#/[^/]*/[^/]*$##'`

# $OSTYPE is a bash builtin variable and bash
# is the /bin/sh that comes with cygwin
ICPATH=$CLASSPATH:.:$TOP
if [ "X$OSTYPE" = "Xwin32" ] ; then
    # win32's interpreter needs semicolon separators
    ICPATH=`echo $ICPATH | sed -e 's/:/;/g'`
fi

# run the lister with the interpreter
if [ "X$BOOTSTRAP" != "X" ]; then
    $BOOTSTRAP "cd $PWD; CLASSPATH=$ICPATH $JAVA toba.Lister $@"
else
    CLASSPATH=$ICPATH $JAVA toba.Lister "$@"
fi
