#!/bin/sh
#
#   check.sh -- check that things look right for a build

must_find()
{
    if type $1 >/dev/null 2>&1 ; then
        return
    else
        echo 
	echo "Could not find '$1':"
	echo "'$1' must be in your path to build Toba."
	echo
	exit 1
    fi
}

must_find java
must_find javac

# Check that there is a class path
if [ "x$CLASSPATH" = "x" ] ; then
    echo
    echo "No CLASSPATH defined:"
    echo "CLASSPATH must contain the class files for the"
    echo "JDK 1.0.2 API in order to build Toba."
    echo
    exit 1
fi

# check that at least one component of the class path actually exists
found_something=0
IFS=:
for component in $CLASSPATH ; do
    if [ -f "$component" -o -d "$component" ] ; then
        found_something=1
    fi
done
IFS=

if [ $found_something -eq 0 ] ; then
    echo
    echo "CLASSPATH not set properly:"
    echo "CLASSPATH must contain the class files for the"
    echo "JDK 1.0.2 API in order to build Toba."
    echo
    exit 1
fi

exit 0
