#include <stdio.h>
#include <stdlib.h>
#include "toba.h"
#include "runtime.h"
#include "java_lang_Float.h"

#ifdef SCOUT
/* scout currently doesn't have this, but we need a prototype to avoid
 * warnings.  It's stubbed out. */
double strtod (const char * nptr, char ** endptr);
#endif /* SCOUT */

/* java/lang/Float toString (F)Ljava/lang/String; */
Object toString_f_DJg0f(Float arg1) 
{
    char buf[20];
 
    /* STATIC Method */
    init_java_lang_Float();

    sprintf(buf, "%g", (double)arg1);
    return javastring(buf);
}

/* java/lang/Float valueOf (Ljava/lang/String;)Ljava/lang/Float; */
Object valueOf_S_CA3lc(Object Harg1) 
{
    struct in_java_lang_String *arg1 = (struct in_java_lang_String *)Harg1;
    struct in_java_lang_Float *ret;
    Float retval;
    char *str, *strend;
 
    /* STATIC Method */
    init_java_lang_Float();

    if(!arg1)
        throwNullPointerException("valueOf");
 
    str = cstring(arg1);
    retval = strtod(str, &strend);
    if(strend == str) 
        throwNumberFormatException(str);
 
    ret = new(&cl_java_lang_Float.C);
    init_f_Bhtg5(ret, retval);
    return ret;
}

/* java/lang/Float floatToIntBits (F)I */
Int floatToIntBits_f_YhK6n(Float arg1) 
{
    Int *retp = (Int *)&arg1;

    /* STATIC Method */
    init_java_lang_Float();

    return *retp;
}

/* java/lang/Float intBitsToFloat (I)F */
Float intBitsToFloat_i_KeitA(Int arg1) 
{
    Float *retp = (Float *)&arg1;

    /* STATIC Method */
    init_java_lang_Float();

    return *retp;
}

