#include <stddef.h>
#include <string.h>

#include "toba.h"
#include "runtime.h"
#include "java_lang_Object.h"
#include "java_lang_Class.h"
#include "java_lang_Cloneable.h"
#include "java_lang_CloneNotSupportedException.h"

/* java/lang/Object getClass ()Ljava/lang/Class; */
Object getClass__zh19H(Object Harg1) 
{
    struct in_java_lang_Object *this = (struct in_java_lang_Object *)Harg1;

    return &this->class->C.classclass;
}

/* java/lang/Object hashCode ()I */
Int hashCode__8wJNW(Object Harg1) 
{
    struct in_java_lang_Object *this = (struct in_java_lang_Object *)Harg1;
    Long l;

    /* we return the address of the instance variable folded into an Int */
    /* assumption: pointers fit into a Long */
    l = (Long)(long)this;
    l = ((l >> 32) ^ l) & 0xffffffff;
    return l;
}

/* java/lang/Object clone ()Ljava/lang/Object; */
Object clone__dslwm(Object Harg1) 
{
    struct in_java_lang_Object *this = (struct in_java_lang_Object *)Harg1;
    struct barray *arr;
    Object res;
    Class cl;
    int clone_ok, i, size;

    /* if it doesn't implement cloneable throw an exception */
    cl = &this->class->C;
    clone_ok = 0;
    if(cl->flags & IS_ARRAY)
        clone_ok = 1;
    for(i = 0; i < cl->ninters; i++) {
        if(cl->inters[i] == &cl_java_lang_Cloneable.C)
            clone_ok = 1;
    }

    if(!clone_ok)
        throwMesg(&cl_java_lang_CloneNotSupportedException.C, "can't clone");

    if(cl->flags & IS_ARRAY) {
        arr = (struct barray *)this;
        res = anewarray(cl->elemclass, arr->length);
	size = offsetof(struct aarray, data[0]) + arr->length * cl->instsize;
    } else {
        /* copy all instance fields -- No constructor is called */
        res = new(cl);
        size = cl->instsize;
    }
    memcpy(res, this, size);
    return res;
}

/* java/lang/Object notify ()V */
Void notify__ne4bk(Object Harg1) 
{
    struct in_java_lang_Object *this = (struct in_java_lang_Object *)Harg1;

    monitornotify(this);
}

/* java/lang/Object notifyAll ()V */
Void notifyAll__iTnlk(Object Harg1) 
{
    struct in_java_lang_Object *this = (struct in_java_lang_Object *)Harg1;

    monitornotifyall(this);
}

/* java/lang/Object wait (J)V */
Void wait_l_1Iito(Object Harg1, Long arg2) 
{
    struct in_java_lang_Object *this = (struct in_java_lang_Object *)Harg1;

    monitorwait(this, arg2);
}

