#include <errno.h>
#include <string.h>
#include "toba.h"
#include "runtime.h"
#include "java_net_DatagramSocket.h"
#include "java_net_DatagramPacket.h"
#include "java_io_FileDescriptor.h"

/* java/net/DatagramSocket datagramSocketCreate ()V */
Void datagramSocketCreate__aFtNv(Object Harg1)
{
    struct in_java_net_DatagramSocket *this = 
        (struct in_java_net_DatagramSocket *)Harg1;
    struct in_java_io_FileDescriptor *fd;
    int unixfd, reuse;

    fd = this->fd;
    if(!fd)
        throwNullPointerException("datagramSocketCreate");

    unixfd = socket(AF_INET, SOCK_DGRAM, 0);
    if(unixfd == -1)
        throwIOException("socket", errno);

    reuse = 1;
    setsockopt(unixfd, SOL_SOCKET, SO_REUSEADDR, (void *)&reuse, sizeof(reuse));

    fd->fd = java_fd(unixfd);
}

/* java/net/DatagramSocket datagramSocketBind (I)I */
Int datagramSocketBind_i_FyMIm(Object Harg1, Int port)
{
    struct in_java_net_DatagramSocket *this = 
        (struct in_java_net_DatagramSocket *)Harg1;
    struct in_java_io_FileDescriptor *fd;
    struct sockaddr_in saddr;
    int res, adlen;

    fd = this->fd;
    if(!fd)
        throwNullPointerException("datagramSocketBind");

    memset(&saddr, 0, sizeof(saddr));
    saddr.sin_family = AF_INET;
    saddr.sin_port = htons(port);
    saddr.sin_addr.s_addr = INADDR_ANY;

    res = bind(unix_fd(fd->fd), (struct sockaddr *)&saddr, sizeof(saddr));
    if(res == -1)
        throwIOException("bind", errno);

    /* 
     * return the actual address bound to - port may
     * be different than value passed in (if port == 0)
     */
    adlen = sizeof(saddr);
    res = getsockname(unix_fd(fd->fd), (struct sockaddr *)&saddr, &adlen);
    if(res == -1)
        throwIOException("getsockname", errno);

    return ntohs(saddr.sin_port);
}

/* java/net/DatagramSocket datagramSocketSend (Ljava/net/DatagramPacket;)V */
Void datagramSocketSend_D_1iUto(Object Harg1, Object Harg2)
{
    struct in_java_net_DatagramSocket *this = 
        (struct in_java_net_DatagramSocket *)Harg1;
    struct in_java_net_DatagramPacket *packet = 
        (struct in_java_net_DatagramPacket *)Harg2;
    struct in_java_io_FileDescriptor *fd;
    struct in_java_net_InetAddress *addr;
    struct barray *buf;
    struct sockaddr_in saddr;
    int res;

    fd = this->fd;
    if(!fd || !packet || !packet->buf || !packet->address)
        throwNullPointerException("datagramSocketSend");
    addr = (struct in_java_net_InetAddress *)packet->address;
    buf = (struct barray *)packet->buf;

    set_address(addr, packet->port, &saddr);
    res = sendto(unix_fd(fd->fd), (char *)buf->data, packet->length, 0,
                 (struct sockaddr *)&saddr, sizeof(saddr));
    if(res == -1)
        throwIOException("sendto", errno);
}

/* receives a packet into buf and fills in addr and port */
static int
do_recv(struct in_java_io_FileDescriptor *fd, struct in_java_net_InetAddress *addr, int *port, char *buf, int len, int flags) 
{
    struct sockaddr_in saddr;
    int res, adlen;

    if(!fd || !addr)
        throwNullPointerException("do_recv");

    adlen = sizeof(saddr);
    res = recvfrom(unix_fd(fd->fd), buf, len, flags,
                   (struct sockaddr *)&saddr, &adlen);
    if(res == -1)
        throwIOException("recvfrom", errno);
    
    addr->address = ntohl(saddr.sin_addr.s_addr);
    addr->family = saddr.sin_family;
    *port = ntohs(saddr.sin_port);
    return res;
}

/* java/net/DatagramSocket datagramSocketPeek (Ljava/net/InetAddress;)I */
Int datagramSocketPeek_I_YWhQJ(Object Harg1, Object Harg2)
{
    struct in_java_net_DatagramSocket *this = 
        (struct in_java_net_DatagramSocket *)Harg1;
    struct in_java_net_InetAddress *addr = 
        (struct in_java_net_InetAddress *)Harg2;
    int port;

    /* check who the next packet is from */
    do_recv(this->fd, addr, &port, 0, 0, MSG_PEEK);
    return port;
}

/* java/net/DatagramSocket datagramSocketReceive (Ljava/net/DatagramPacket;)V */
Void datagramSocketReceive_D_ohMvt(Object Harg1, Object Harg2)
{
    struct in_java_net_DatagramSocket *this = 
        (struct in_java_net_DatagramSocket *)Harg1;
    struct in_java_net_DatagramPacket *packet = 
        (struct in_java_net_DatagramPacket *)Harg2;
    struct in_java_net_InetAddress *addr;
    struct in_java_io_FileDescriptor *fd;
    struct barray *buf;
    int res, port;

    fd = this->fd;
    if(!fd || !packet || !packet->buf)
        throwNullPointerException("datagramSocketReceive");
    buf = (struct barray *)packet->buf;

    addr = (struct in_java_net_InetAddress *)
        construct(&cl_java_net_InetAddress.C);
    res = do_recv(this->fd, addr, &port, (char *)buf->data, buf->length, 0);

    packet->address = addr;
    packet->length = res;
    packet->port = port;
}

/* java/net/DatagramSocket datagramSocketClose ()V */
Void datagramSocketClose__SijQP(Object Harg1)
{
    struct in_java_net_DatagramSocket *this = 
        (struct in_java_net_DatagramSocket *)Harg1;

    fd_close(this->fd);
}

