/* runtime.h -- prototypes and definitions for native code helpers */

#ifndef _runtime_h_
#define _runtime_h_

#include "java_lang_String.h"
#include "java_lang_Class.h"
#include "java_io_FileDescriptor.h"
#include "java_net_InetAddress.h"
#include "java_lang_Process.h"

#include <sys/types.h>
#ifdef SCOUT
/* Unix values */
#define INADDR_ANY 0
#define AF_INET 2
#else /* SCOUT */
#include <sys/stat.h>
#include <sys/socket.h>
#endif /* SCOUT */
#include <netinet/in.h>

/* Detect glibc2 on Linux, in case user didn't provide this flag.  We need
 * to know format of setjmp for jit. */
#if (! defined (WITH_GLIBC2)) && defined (linux)
#include <features.h>
#if (2 <= __GLIBC__)
#define WITH_GLIBC2 (1)
#endif /* 2 <= __GLIBC__ */
#endif /* linux/glibc2? */

/* implementation identification */
#define JAVA_VERSION 	"1.0.2"		/* Java spec version */
#define CLASS_VERSION	"45.3"		/* Java classfile version */
#define TOBA_VENDOR	"The University of Arizona"
#define TOBA_URL	"http://www.cs.arizona.edu/sumatra/"
#define TOBA_VERSION	"1.0"	/* our own version number */
/* NB: For static joust in Scout, if this toolkit changes, the patch
 * to java.awt.Toolkit must be updated to force inclusion of the toolkit,
 * which is looked up by name only. */
#define AWT_TOOLKIT	"biss.awt.kernel.Toolkit"

#define TOBA_PREFIX	"TOBA_"		/* prefix for environmentals */
#define TOBA_PREFIX_LEN	5		/* strlen(TOBA_PREFIX) */

/* default configuration */
#define DEFAULT_HEAP	(1024 * 1024)	/* default initial heap size */

/* unix separator characters */
#define PATH_SEPARATOR	":"
#define FILE_SEPARATOR	"/"
#define LINE_SEPARATOR	"\n"

/* class flags */
#define IS_INTERFACE 0x0001	/* class is an interface class */
				/* (MUST BE 1; assumed so by Opcode.java) */
#define IS_ARRAY     0x0002	/* class represents an array */
#define IS_PRIMITIVE 0x0004	/* class represents a primitive type */
#define IS_SETUP     0x0010	/* class has had load-time setup done */
#define IS_SETUP2    0x0020	/* class has had second-phase load-time setup done */

/* java.lang.Object initializer & finalizer */
#define OBJ_INIT init__AAyKx
#define OBJ_FINI finalize__UKxhs
#define OBJ_METHODS (cl_java_lang_Object.M)

/* Java representations */
#define JAVA_FALSE	0
#define JAVA_TRUE	1
#define MIN_JAVA_INT ((Int) 0x80000000)
#define MAX_JAVA_INT ((Int) 0x7FFFFFFF)
#define MIN_JAVA_LONG ((Long)((ULong)1 << 63))
#define MAX_JAVA_LONG (~MIN_JAVA_LONG)

#if HAVE_TCLASS_NAME_LIST
/* Any executable program has within it an array containing the
 * addresses of all Toba Classes that are defined within the
 * executable.  Need this to implement Class.forName when dynamic
 * loading is not available.  The list is null-terminated. */
extern Class tclass_name_list [];
#endif /* HAVE_TCLASS_NAME_LIST */

/* prototypes, excluding those listed in toba.h for use by generated code */

/* alloc.c */
void meminit(void);
void memexit(void);
void *allocate(int nbytes);
void *allocateuncol(int n_bytes);
void finalizer(void *address, void (*func)(void *));
Object construct(Class c);
Class arrayclassof(Class c);

/* loader.c */
void loader_init();

/* binary_loader.c */
void binary_loader_init();
struct in_java_lang_Class *load_native_system_class(struct in_java_lang_String *); 
Boolean load_native_library(struct in_java_lang_String *);
void *load_native_method(struct in_java_lang_String *, struct in_java_lang_String *,
			 struct in_java_lang_String *);

/* file.c */
Void fd_open(struct in_java_io_FileDescriptor *fd, Object unameo, int oflags);
Int fd_read_char(struct in_java_io_FileDescriptor *fd);
Int fd_read_bytes
    (struct in_java_io_FileDescriptor *fd, Object Harg2, Int off, Int len);
Void fd_close(struct in_java_io_FileDescriptor *fd);
Void fd_write_char(struct in_java_io_FileDescriptor *fd, Int arg2);
Void fd_write_bytes
    (struct in_java_io_FileDescriptor *fd, Object Harg2, Int off, Int len);
#ifdef SCOUT
int name_attr(struct in_java_lang_String *uname, FsFileAttr file_attr);
#else /* SCOUT */
int name_stat(struct in_java_lang_String *uname, struct stat *buf);
#endif /* SCOUT */
Boolean name_access(struct in_java_lang_String *uname, int amode);
int java_fd(int unixfd);
int unix_fd(int javafd);
int java_fd_valid(int javafd);
#ifdef SCOUT
long fd_lseek(struct in_java_io_FileDescriptor *fd, long offset, long whence);
Void fix_file_path(char *name, char *full_name);
Stage open_file(struct in_java_lang_String *uname, FsOpenFlags flags,
                FsFMode mode);
#else /* SCOUT */
void set_address
   (struct in_java_net_InetAddress *jaddr, Int port, struct sockaddr_in *uaddr);
#endif /* SCOUT */

/* finalizer.c */
void finalization_init(void);
void finalizer_queue_prealloc();
void needs_finalization(Object o, void (*f)(void*));
void run_some_finalizers(struct mythread *thr, int num);

/* helpers.c */
/* (all functions are prototyped in toba.h) */

/* intern.c */
struct in_java_lang_String *intern_string(struct in_java_lang_String *str);
void intern_string_init();

/* lang_Class.c */
void register_class(Class cl);
struct in_java_lang_Class *find_classclass(Class cl);
Class find_class(struct in_java_lang_Class *cl);

/* lang_*Process.c */
struct in_java_lang_Process *create_process(Object args, Object env);

/* monitor.c */
void monitor_package_init(void);
void monitorwait(void *address, Long timeout);
void monitornotify(void *address);
void monitornotifyall(void *address);
void fixup_monitors(void);

/* runtime.c */
void start_thread(Void startfunc(Object o), Object arg);
void terminate(int status);
void fatal(char *mesg);
void unimpl(char *name);
char *cstring(const struct in_java_lang_String *str);
struct in_java_lang_String *javastring(const char *cstr);
struct in_java_lang_String *arraystring(const Char *a, int n);

#ifdef OPTION_JIT
/* These are invoked to support jit compilation. */
void class_loader_init (); /* defined in runtime_SystemClassLoader.c */
void codegen_init (); /* defined in arch_md.c */
#endif /* OPTION_JIT */

/* structs.c */
void initstructs(void);

/* java_lang_Class.c */
void set_main_class(Class c);

/* throw.c */

/* Call this to throw a java.lang.InternalError, e.g. for when runtime
 * assumptions are violated.  This is a varargs function like printf */
void
throwInternalError (char *msg,
                    ...);

void throwMesg(Class etype, char *mesg, ...);

void throwArrayIndexOutOfBoundsException(Object o, int index);
void throwArrayStoreException(char *mesg);
void throwClassCastException(Object o);
void throwClassCircularityError(Object o);
void throwClassNotFoundException(char *mesg);
void throwEOFException(char *mesg, int xerrno);
void throwExceptionInInitializerError(Object o);
void throwFileNotFoundException(char *mesg, int xerrno);
void throwIOException(char *mesg, int xerrno);
void throwIllegalAccessException(char *mesg);
void throwIncompatibleClassChangeError(Object o);
void throwIndexOutOfBoundsException(char *mesg);
void throwInstantiationException(Object o);
void throwInterruptedIOException(char *mesg, int xerrno);
void throwNegativeArraySizeException(int size);
void throwNoSuchMethodError(Object o);
void throwNumberFormatException(char *mesg);
void throwOutOfMemoryError(int nbytes);
void throwUnknownHostException(char *mesg);

#endif /* _runtime_h_ */

