/* Native routines for the Toba internal class loader */
#include "toba.h"

#include "java_lang_ClassLoader.h"
#include "java_lang_String.h"
#include "toba_classfile_ClassData.h"
#include "toba_runtime_ClassRT.h"
#include "toba_runtime_SystemClassLoader.h"

#include "runtime.h"

struct in_toba_runtime_SystemClassLoader *system_loader = 0;

/* Initialize the data structure for the class loader */
void class_loader_init() {
    /* This routine will be called at least once before the system starts 
     * a second thread, so there's not a race condition here. */
    if (system_loader == 0)
	system_loader = construct(&cl_toba_runtime_SystemClassLoader.C);
    return;
}

/* install a class in the System Loader's hashtable 
 * (called during startup) */
void
register_class(Class cl)
{
    class_loader_init();
    system_loader->class->
	M.registerNewClass_SC_3gNeo.f(system_loader, cl->name, 
				      find_classclass(cl));
}


/* Because loader.loadClass is protected, we can't call it directly from
 * java, so we define this native method */
Object invokeLoader_CSz_l1buK(Object arg1, Object arg2, Boolean resolve)
{
    struct in_java_lang_ClassLoader *loader = arg1;
    return loader->class->M.loadClass_Sz_ri6SJ.f(arg1, arg2, resolve);
}

Object findNativeClass_S_o7CeC(Object arg1)
{
    return load_native_system_class(arg1);
}

Object getSystemLoader__yUdq4() 
{
    return system_loader;
}
