/* $Id: x86_md.c,v 1.14 1998/02/25 18:05:23 pab Exp $
 * Machine-dependent code for the Intel x86
 * generate_trampoline, which returns the routine invoked to enter some common
 *   entry point, like the interpreter or the compiler.
 *
 * This code is used by several execution methods, including the interpreter
 * and the jit-compiler.  Code specific to one or another of those methods
 * lives in method-specific modules.
 */

#include <stddef.h>
#include <stdarg.h>
#include <assert.h>
#include <alloca.h>

#include "toba.h"
#include "runtime.h"
#include "sthreads.h"

/* We don't include md.h as we have to declare functions
 * different than they were prototyped in md.h */
/* #include "md.h" */

#ifdef LINUX
#include <fpu_control.h>
#endif

#if defined(_WIN32) /* WindowsNT or Windows95 */
#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include <windows.h>
#endif

/* Machine-dependent initialization code */
void md_init() {
#ifdef LINUX
  __setfpucw(_FPU_IEEE);
#endif
}

#ifdef OPTION_JIT
#include "toba_runtime_CodeGen.h"
#include "toba_jit_JITCodeGen.h"
#endif /* OPTION_JIT */

/*
 * codegen_init() - choose a code generator for the architecture 
 */
void codegen_init() 
{
#ifdef OPTION_JIT
   struct in_toba_jit_JITCodeGen * gen;

   Initialize__ek3Oa(); /* This is the JIT code generator */
   gen = cl_toba_runtime_CodeGen.V.generator;
   if (NULL == gen) {
      throwInternalError ("JIT code generator not available.");
   }

#ifdef WITH_GLIBC2
   /* GNU libc 2 (glibc, or libc-6) doesn't provide a __setjmp
    * function; instead it calls __sigsetjmp(_jbuf, 0).  We need to
    * notify the jit that it needs to set up a second argument
    * before calling the setjmp function. */
   gen->useBinarySetjmp = JAVA_TRUE;
#else /* WITH_GLIBC2 */
   /* Normal setjmp; only arg is the jump buffer. */
   gen->useBinarySetjmp = JAVA_FALSE;
#endif /* WITH_GLIBC2 */

    /** With SCOUT_THREADS, the overhead of pre-emption handling with calling
      * yield on each back edge is too high; use a comparison between two
      * longs to determine whether the time has reached a point where it
      * is appropriate to call the yield function. */
#ifdef SCOUT_THREADS
   gen->useScoutThreadPreemption = JAVA_TRUE;
#else /* SCOUT_THREADS */
   gen->useScoutThreadPreemption = JAVA_FALSE;
#endif /* SCOUT_THREADS */

#endif /* OPTION_JIT */
}
