/* Redefinition of the execve system call, so that we can remove the 
 * non-blocking flags from the files we marked as non-blocking and 
 * asynchronous */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>


int 
reestablishFileDesc(int fd)
{
    return fcntl(fd, F_SETFL, (FASYNC|FNDELAY));
}

int
resetFileDesc(int fd) 
{
    return fcntl(fd, F_SETFL, 0);
}

int __wrap_execve(const char *filename, const char *argv[], const char *envp[])
{
    int i, ret;

    /* Reset all of the open files to blocking and synchronous */   

    for (i = fdescGetFirstOpen(); i >= 0; i = fdescGetNextOpen(i)) {
	if (resetFileDesc(i) == -1)
	    perror("reset file desc");
    }

    /* Call execve. It normally doesn't return. */
    ret = __real_execve(filename, argv, envp);

    /* What to do if exec returns??? We need to re-setup the file 
     * descriptors to non-blocking and asynchronous. */
    for (i = fdescGetFirstOpen(); i >= 0; i = fdescGetNextOpen(i)) {
	if (reestablishFileDesc(i) == -1)
	    perror("reset file desc");
    }

    return ret;
}
