/* Redefinition of the open system call, so that we can mark it
 * as non-blocking and asynchronous */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdarg.h>

int
setupFileDesc(int fd, int flags) 
{
    int ret;

    /* Now register this file as open */
    fdescOpen(fd, flags);

    /* Give my process group ownership of this FD */
    ret = fcntl(fd, F_SETOWN, -getpgrp());

    if (ret == -1) {
	close(fd);
	return -1;
    }

    /* Make it non-blocking */
    ret = fcntl(fd, F_SETFL, (FASYNC|FNDELAY));

    if (ret == -1) {
	close(fd);
	return -1;
    }

    return fd;
}

int __wrap_open(const char *pathname, int flags, ...)
{
    int fd, ret;

    if (flags & O_CREAT) {
	va_list args;
	mode_t mode;
	va_start(args, flags);
	mode = va_arg(args, mode_t);
	va_end(args);
	fd = __real_open(pathname, flags | O_NONBLOCK, mode);
    } else {
	fd = __real_open(pathname, flags | O_NONBLOCK);
    }

    if (fd == -1)
	return -1;

    return setupFileDesc(fd, flags);
}
