/* Redefinition of the open system call, so that we can mark it
 * as non-blocking and asynchronous */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <fcntl.h>

int __wrap_pipe(int *filedes)
{
    int ret;

    ret = __real_pipe(filedes);

    if (ret == -1)
	return -1;

    if (setupFileDesc(filedes[0]) == -1)
	perror("pipe[0] setup");
    if (setupFileDesc(filedes[1]) == -1)
	perror("pipe[1] setup");

    return ret;
}
