/* signals.c - signal handling for the system-call wrappers */

#include <stddef.h>
#include <signal.h>

void
defineHandler(int sig, void (*handler)())
{
    struct sigaction act;

    if (handler == SIG_IGN) {
        sigemptyset (&act.sa_mask);
        act.sa_handler = SIG_IGN;
        act.sa_flags = 0;
        sigaction(sig, &act, NULL);
    } else {
        act.sa_handler = handler;
        sigfillset(&act.sa_mask);
        act.sa_flags = SA_RESTART;
        sigaction (sig, &act, NULL);
    }
    return;
}

