/* testprog.c - simple scout threads/UNIX system call 
 * test program */

#include <scout_thread.h>

#include <stdlib.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>



void *
allocate(size_t nbytes) 
{
    return (void *)malloc(nbytes);
}

/* Various random number generation routines */
void 
randomInit() 
{
    srandom(clock());
}

long 
randomLong(int lower, int upper) 
{
    long randomNum = random();
    double scale = ((float)randomNum / (float)RAND_MAX);
    return (scale * (upper - lower)) + lower;
}

void 
randomString(char *buf, int len)
{
    int i;
    for (i = 0; i < len; i++)
	buf[i] = (unsigned char)randomLong(0,255);
}

void sendstring(int sock, char *str, int len)
{
    int res;
    while (len > 0) {
	res = write(sock, str, len);
	if (res < 0) {
	    perror("write");
	    exit(-1);
	} else {
	    len -= res;
	    str += res;
	}
	
    }
}

int getstring(int sock, char *str, int len)
{
    int res;
    int nread = 0;
    while (len > 0) {
	res = read(sock, str, len);
	if (res < 0) {
	    perror("write");
	    exit(-1);
	} else if (read == 0) {
	    return nread;
	} else {
	    nread += res;
	    str += res;
	    len -= res;
	}
    }
    return nread;
}

void 
echotalk(int sock)
{
    char out[1024], in[1024];

    randomInit();

    while(1) {
	int len = randomLong(1,1024);
	randomString(out, len);
	sendstring(sock, out, len);
	if (getstring(sock, in, len) != len) {
	    fprintf(stderr, "Echoed string of different length!\n");
	    exit(-1);	    
	}
	if (memcmp(in, out, len) != 0) {
	    fprintf(stderr, "Echoed string not equal\n");
	    exit(-1);
	} else {
	    fprintf(stdout, "Echoed string is correct.\n");
	    fflush(stdout);
	}
        threadYield();
    }
}


void 
echoThread(char *servername)
{

    /* Open a socket to a web server */
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    u_int remaddr;
    struct hostent *remhost;
    struct sockaddr_in cli_addr, serv_addr;

    if (sock < 0) {
	perror("socket");
	exit(-1);
    }

    remhost = gethostbyname(servername);
    if (remhost == 0) {
	perror("gethostbyname");
	exit(-1);
    }

    remhost->h_addr;

    bzero((char *)&serv_addr, sizeof(serv_addr));
    bcopy(remhost->h_addr, (char *)&serv_addr.sin_addr, remhost->h_length);
    serv_addr.sin_family = remhost->h_addrtype;
    serv_addr.sin_port = htons((u_short)7);

    if (connect(sock, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
	perror("connect");
	exit(-1);
    }

    /* Begin talking to the server, sending lines and receiving them,
     * since we're talking to the echo server. */
    echotalk(sock);

    close(sock);
    exit(0);
}

void foobar() {
    return;
}
void printFunc(int foo)
{
    int i;
    while(1) {
	for (i = 0; i < 10000000; i++)
	    ;
	threadYield();
	fprintf(stdout, "+");
	fflush(stdout);
    }
}

void testStart(int foo) 
{
    struct ThreadOptions options;
    Thread t1;
    Thread t2;

    /* iowrapInit(); */

    options.arg  = 0;
    options.scheduler = 0;
    options.priority = THREAD_PRIO_STD;

    options.name = "print thread";
    t1 = threadCreate((ThreadFunc)printFunc, &options);

    options.arg = "bas";
    options.name = "echo thread";
    t2 = threadCreate((ThreadFunc)echoThread, &options);

    threadWakeup(t1);
    threadWakeup(t2);
}

int 
main(int argc, char **argv) 
{
    threadInit((ThreadFunc)testStart, 0);
}
