/* Routine to handle blocking waits using conditions, signals, and
 * non-blocking waits. This prevent the entire system from freezing
 * when wait() is called. */

#include <sys/types.h>
#include <sys/wait.h>
#include <errno.h>

#include "scout_semaphore.h"

struct Semaphore waitSema;

pid_t
__wrap_waitpid(pid_t pid, int *status, int options)
{
    int ret;

    if ((options & WNOHANG) != 0) {
	return __real_waitpid(pid, status, options);
    } else {
	while ((ret = __real_waitpid(pid, status, (options | WNOHANG))) == 0) {
	    /* There are no children ready to be waited on, so 
	     * wait on a semaphore that SIGCHLD will broadcast. */
	    semaphoreWait(&waitSema);
	}
	return ret;
    }
}


void
waitSignal() {
    semaphoreSignalAll(&waitSema);
}

void
waitInit() {
    semaphoreInit(&waitSema, 0);
}
