#ifndef __alpha_synch_h__
#define __alpha_synch_h__

#include <alpha/pal.h>

#define SYNCH_MAX_ATOMIC_SEQUENCE_LENGTH	(32*4)	/* [bytes] */

#ifndef LANGUAGE_ASSEMBLY 

#ifndef USER_LEVEL

extern inline long
synchEnableInterrupts (void)
{
    register long result asm ("0");

    asm volatile ("bis $31,$31,$16; call_pal %1 # %0"
		  : "r="(result)
		  : "i"(PALOSF_swpipl)
		  : "memory", "0", "1", "16", "22", "23", "24", "25");
    return result;
}

extern inline long
synchDisableInterrupts (void)
{
    register long result asm ("0");

    asm volatile ("bis $31,7,$16; call_pal %1 # %0"
		  : "r="(result)
		  : "i"(PALOSF_swpipl)
		  : "memory", "0", "1", "16", "22", "23", "24", "25");
    return result;
}

extern inline void
synchRestoreInterrupts (long flags)
{
    asm volatile ("bis %1,$31,$16; call_pal %0 #"
		  :
		  : "i"(PALOSF_swpipl), "r"(flags)
		  : "memory", "0", "1", "16", "22", "23", "24", "25");
}

#endif /* USER_LEVEL */

#ifdef NDEBUG
# define SYNCH_IF_DEBUG(arg)
#else
# define SYNCH_IF_DEBUG(arg)	arg
#endif

#define synchAtomicSequence(as)						\
({									\
   SYNCH_IF_DEBUG(__label__ the_start;)					\
   __label__ the_end;							\
   register void * end_pc asm ("$1");					\
   SYNCH_IF_DEBUG(asm volatile ("" :: "r"(&&the_start));)		\
   assert(&&the_end - &&the_start < SYNCH_MAX_ATOMIC_SEQUENCE_LENGTH);	\
   asm volatile ("" ::: "memory");					\
 SYNCH_IF_DEBUG(the_start:)						\
   end_pc = &&the_end;							\
   asm volatile ("" ::: "memory");					\
   {as;}								\
   asm volatile ("jmp %0,(%1),0"					\
		 : "r="(end_pc) : "0"(end_pc) : "memory");		\
   asm volatile ("" ::: "memory");					\
 the_end:								\
})

#endif /* LANGUAGE_ASSEMBLY */

#endif /* __alpha_synch_h__ */
