/* 
 * @COPYRIGHT@
 * @COPYRIGHT@
 *
 * $RCSfile: scout_fifo.h,v $
 *
 * HISTORY
 * $Log: scout_fifo.h,v $
 * Revision 1.1  1997/09/19 20:25:11  bridges
 * Rearranged architecture files, build environment.
 * Added code to prevent blocking in many system calls.
 *
 * Revision 1.2  1997/01/14 07:49:55  davidm
 * [fifoIsEmpty]: New macro.
 *
 * Revision 1.1  1996/05/24 23:20:10  davidm
 * Initial revision
 *
 */
#ifndef __fifo_h__
#define __fifo_h__

/*
 * This module provides a FIFO queueing service for multiple producers
 * and a single consumer that operate concurrently.  Usually, "remove"
 * can be invoked concurrently without incurring any synchronization
 * overheads.  The only case where synchronization overheads occur during
 * "remove" is when removing the last element in a queue.
 */

typedef struct FIFO *	FIFO;
typedef struct FIFOEl *	FIFOEl;

struct FIFO {
    FIFOEl	head;
    FIFOEl	tail;
};

struct FIFOEl {
    FIFOEl	next;
};

extern void	fifoInit (FIFO q);
extern void	fifoAppend (FIFO q, void *element);
extern void	fifoAppendUnsafe (FIFO q, void *element);
extern void *	fifoRemove (FIFO q);

/*
 * This is a macro rather than an inlined function since we must
 * guarantee that it does not result in a flow-control change
 * (such as a function call).  Guaranteeing this allows using
 * this as part of a synchAtomicSequence().
 */
#define fifoIsEmpty(q)	(!(q)->head)

#endif /* __fifo_h__ */
