/* 
 * Copyright (c) 1993,1991,1990,1996  Arizona Board of Regents
 *
 * $RCSfile: scout_queue.h,v $
 *
 * HISTORY
 * $Log: scout_queue.h,v $
 * Revision 1.1.1.1  1997/08/29 22:41:02  bridges
 * Import of scout threads
 *
 * Revision 1.1  1997/05/01 18:12:50  acb
 * Initial revision
 *
 * Revision 1.1  1997/01/28  22:38:20  rrp
 * Initial revision
 *
 * Revision 1.1  1996/10/02 13:31:44  davidm
 * Initial revision
 *
 */
#ifndef __queue_h__
#define __queue_h__

/*
 * This module provides a general queueing service if producers and
 * consumers operate synchronously (i.e., under control of
 * scout_thread.c).
 */

typedef struct Queue *		Queue;
typedef struct QueueEl *	QueueEl;

struct QueueEl {
    QueueEl	next;
};

struct Queue {
    QueueEl	head;
    QueueEl	tail;
};

extern void	queueInit (Queue q);
extern void	queueAppend (Queue q, void * element);
extern void	queueInsert (Queue q, void * after, void * element);
extern void *	queueRemove (Queue q);
extern void	queueDelete (Queue q, void * after);
extern QueueEl	queueHead (Queue q);
extern QueueEl	queueTail (Queue q);

#endif /* __queue_h__ */
