/*
 * @COPYRIGHT@
 * @COPYRIGHT@
 *
 * $RCSfile: scout_semaphore.c,v $
 *
 * HISTORY
 * $Log: scout_semaphore.c,v $
 * Revision 1.1.1.1  1997/08/29 22:41:02  bridges
 * Import of scout threads
 *
 * Revision 1.1  1997/05/01 18:12:50  acb
 * Initial revision
 *
 * Revision 1.1  1996/10/02 13:41:54  davidm
 * Initial revision
 *
 */
/*
 * Counting semaphores implemented on top of threads package.
 */

#include <memory.h>
#include <stdio.h>
#include <strings.h>
#include "scout_semaphore.h"
#include "scout_thread.h"


void
semaphoreInit(Semaphore s, unsigned int initialVal)
{
    s->count = initialVal;
    queueInit(&s->waitingQ);
}


void
semaphoreWait(Semaphore s)
{
    if (--s->count < 0) {
	queueAppend(&s->waitingQ, tSelf);
	threadSuspend();
    }
}


void
semaphoreSignal(Semaphore s)
{
    Thread t;

    if (s->count++ < 0) {
	t = queueRemove(&s->waitingQ);
	threadWakeup(t);
    }
}


int
semaphoreCount (Semaphore s)
{
    return s->count;
}


extern void
semaphoreSignalAll (Semaphore s)
{
    int i, nblocked = -s->count;

    for (i = 0; i < nblocked; ++i) {
	semaphoreSignal(s);
    }
}
