/*
 * @COPYRIGHT@
 * @COPYRIGHT@
 *
 * $RCSfile: scout_semaphore.h,v $
 *
 * HISTORY
 * $Log: scout_semaphore.h,v $
 * Revision 1.1.1.1  1997/08/29 22:41:02  bridges
 * Import of scout threads
 *
 * Revision 1.1  1997/05/01 18:12:50  acb
 * Initial revision
 *
 * Revision 1.1  1996/10/02 13:34:35  davidm
 * Initial revision
 *
 */
#ifndef __semaphore_h__
#define __semaphore_h__

#include "scout_queue.h"

typedef struct Semaphore *	Semaphore;

struct Semaphore {
    int			count;
    struct Queue	waitingQ;
};

extern void	semaphoreInit (Semaphore s, unsigned int initialVal);
extern void	semaphoreWait (Semaphore s);
/*
 * semSignal does not constitute a scheduling point.  Calling thread
 * is guaranteed to resume execution immediately.
 */
extern void	semaphoreSignal (Semaphore s);
/*
 * Let n=semaphoreCount(s).  Then n>=0 => can perform n semaphoreWait() before
 * blocking, or if n<0 => there are -n threads blocked on semaphore.
 */
extern int	semaphoreCount (Semaphore s);
/*
 * semaphoreSignalAll is identical to:
 *	for (i = 0; i < -semaphoreCount(s); ++i) semaphoreSignal(s);
 */
extern void	semaphoreSignalAll (Semaphore s);

#endif /* __semaphore_h__ */
