#ifndef __x86_synch_h__
#define __x86_synch_h__


#ifndef LANGUAGE_ASSEMBLY

#ifndef USER_LEVEL

extern inline long
synchEnableInterrupts (void)
{
    register long result;

    asm volatile ("pushfl ;
		   popl %0 ;
		   sti"
		  : "r="(result)
		  : );
    return result;
}

extern inline long
synchDisableInterrupts (void)
{
    register long result;
    asm volatile (" ;
		   pushfl ;
		   popl %0 ;
		   cli ;"
		  : "r="(result)
		  : );
    return result;
}


extern inline void
synchRestoreInterrupts (long flags)
{
    asm volatile ("pushl %0;
		   popfl ; "
		  :
		  : "r"(flags)
		  : "cc");
}

#endif /* USER_LEVEL */

#define synchAtomicSequence(as)						\
({									\
    register long as_flags;						\
    as_flags = synchDisableInterrupts();				\
    {as;}								\
    synchRestoreInterrupts(as_flags);					\
})


#endif /* LANGUAGE_ASSEMBLY */

#endif /* __x86_synch_h__ */
