/*
 * $RCSfile: scout_thread.h,v $
 *
 * x-kernel v3.3
 *
 * Copyright (c) 1993,1991,1990,1996  Arizona Board of Regents
 *
 * $Log: scout_thread.h,v $
 * Revision 1.2  1998/02/02 17:00:05  pab
 * Remove -g from config, eliminate scoutthread compile warnings, draft glibc2 support
 *
 * Revision 1.1  1997/09/19 20:26:53  bridges
 * Relocation of machine-dependent files, addition of scout_synch.h to
 * support the machine-dependent portions of scout threads synchronization.
 *
 * Revision 1.1.1.1  1997/08/29 22:41:03  bridges
 * Import of scout threads
 *
 * Revision 1.1  1997/05/01 18:12:50  acb
 * Initial revision
 *
 * Revision 1.1  1997/01/18  00:33:45  dlarson
 * Initial revision
 *
 *
 */
/*
 * This must not be included by anything but thread.c.  That's
 * why this file is not protected by #ifdefs.
 */

/*
 * x86 register usage (gcc):
 *
 * Callee saved registers:	ebx, edi, esi, ebp
 *	ebp = frame pointer (FP)
 *	esp = stack pointer (SP)
 *
 * Callee does not need to save any floating point regs, so the FPU macros
 * are not needed.
 *
 */

#define MAGIC_COOKIE		0xFEEDF001
#define MIN_STACK_SIZE		(1024)	/* enough for a single printf() */
#define MIN_USEFUL_STACK_SIZE	(2*MIN_STACK_SIZE)
/* #define DEFAULT_STACK_SIZE	(8*MIN_USEFUL_STACK_SIZE) */
#define DEFAULT_STACK_SIZE	(128*MIN_USEFUL_STACK_SIZE) /* make a really big stack, for now... */
#define FPU_STATE_SIZE		(9*sizeof(long))


/*
 * Switch to stack TO_SP, discarding the old stack pointer and invoke
 * start().
 */
#define SWITCH_STACK_AND_START(to_sp, start)				\
{									\
    asm volatile							\
      ("movl %0, %%esp
	jmp  %1
       ":						/* output */	\
	: "r" (to_sp), "r" (start));			/* input */	\
}

/*
 * Save necessary state on stack, save new stack pointer to
 * variable saved_sp.
 */
#define SAVE_STATE(saved_sp)						\
{									\
    asm volatile							\
      ("push %%ebx
	push %%edi
	push %%esi
	push %%ebp
	movl %%esp, %0
       ": "m=" (saved_sp)				/* output */	\
	:						/* input */	\
	: "memory");					/* modified */	\
}


/*
 * Load state stored at FROM_SP.
 */
#define LOAD_STATE(from_sp)						\
{									\
    asm volatile							\
      ("movl %0, %%esp
	popl %%ebp
	popl %%esi
	popl %%edi
	popl %%ebx
       ":						/* output */	\
	: "m" (from_sp));				/* input */	\
}

#define SAVE_FPU_STATE(fpu_state)
#define LOAD_FPU_STATE(fpu_state)

#define FPU_ON
#define FPU_OFF

/* this is for debugging purposes only: */
#define GET_SAVED_PC(sp) ((void*)0)

