//  ClassRef.java -- a reference to a Class in a Constant table

package toba.classfile;
import java.util.*;

public class ClassRef {
    public String name;
    private Class refClass;  // the referred-to class
    private static Hashtable rccache;

    static {
        rccache = new Hashtable ();
    }

    /* Use this to register class ref structures created elsewhere, e.g. in
     * tobafied code.  This is called from runtime.c/register_crefs, which is
     * to be called around the same time as walk_classes.
     * Toba hash code: _C_2Ejuw
     */
    public static void
    RegisterClassRef (ClassRef cr)
    {
        rccache.put (cr.name, cr);
        return;
    }
                      
    /* For this to work, ClassRefs in tobafied source files need to be added
     * to the cache, else we'll duplicate (for example) interface class
     * structures when we look them up by name at runtime. */
    public static ClassRef
    byName (String s)
    {
        ClassRef cr;

        cr = (ClassRef) rccache.get (s);
        if (null == cr) {
            cr = new ClassRef (s);
            rccache.put (s, cr);
        }
        return cr;
    }

    // The constructor called when parsing class files
    private ClassRef(String s) {
	name = s;
	refClass = null;
    }
    
    public boolean isResolved() {
	if (refClass == null)
	    return false;
	else
	    return true;
    }

    public void resolveTo(Class cl) {
	refClass = cl;
    }

    public Class getRefClass() {
	if (!isResolved())
	    throw new NoClassDefFoundError("Reference to class " + name + " is unresolved.");
	
	return refClass;
    }

    public String toString() {
	return name;
    }
};
