//  MethodRef.java -- a Method or InterfaceMeth ref in a Constant table

package toba.classfile;

public class MethodRef extends FieldRef {
    public MethodRef(ClassRef cl, String n, String s) { super(cl, n, s); }

    // Locate the method that this reference refers
    // to in the given ClassData
    protected Field findMethod(ClassData cdata) {
	Field[] imtable = cdata.imtable;

	for (int i = 0; i < imtable.length; i++) {
	    if ((name == imtable[i].name) && 
		(signature == imtable[i].signature)) {
		return imtable[i];
	    }
	}

	Field[] smtable = cdata.smtable;
	for (int i = 0; i < smtable.length; i++) {
	    if ((name == smtable[i].name) && 
		(signature == smtable[i].signature)) {
		return smtable[i];
	    }
	}
	throw new NoSuchMethodError(name + signature);
    }

    public void resolveWith(ClassData cdata) {
	resolveTo(findMethod(cdata));
    }
};
