//  Supers.java -- operations involving superclasses for the runtime

package toba.runtime;

import toba.classfile.*;
import java.io.IOException;

class Supers {

// load and define the superclasses and interfaces of a given class
static void load(ClassData cdata, ClassLoader loader) 
    throws ClassNotFoundException, NoClassDefFoundError, IOException
{
    // If we done any resolution on the class, we've already 
    // loaded superclasses
    if (cdata.state != ClassData.RES_NONE)
	return;

    if (cdata.supername != null) {
	// We don't resolve our superclass yet, to avoid any
	// circular loading problems
	Class sc = SystemClassLoader.invokeLoader(loader, cdata.supername, 
						  false);
	ClassData sccdata = ClassRT.getClassData(sc);
	if (sccdata == null) {
	    throw new NoClassDefFoundError(cdata.supername);
	}
	cdata.superclass = sccdata;
    }

    cdata.state = ClassData.RES_SUPERCLASSES;

    cdata.buildTables();
//    System.out.println ("After Supers.load: class data:\n" + cdata);
    IHash.mark(cdata);
    return;
}

}
